/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.ErrorInitializer;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ParameterDeclaration;
import io.quarkus.qute.Parser;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResolutionContextImpl;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionInitContextImpl;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

class SectionNode
implements TemplateNode {
    private static final Logger LOG = Logger.getLogger((String)"io.quarkus.qute.nodeResolve");
    final String name;
    final List<SectionBlock> blocks;
    final SectionHelper helper;
    private final TemplateNode.Origin origin;
    private final boolean traceLevel;

    static Builder builder(String helperName, TemplateNode.Origin origin, Parser parser, ErrorInitializer errorFun) {
        return new Builder(helperName, origin, parser, errorFun);
    }

    SectionNode(String name, List<SectionBlock> blocks, SectionHelper helper, TemplateNode.Origin origin) {
        this.name = name;
        this.blocks = blocks;
        this.helper = helper;
        this.origin = origin;
        this.traceLevel = LOG.isTraceEnabled();
    }

    public CompletionStage<ResultNode> resolve(ResolutionContext context, Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (this.traceLevel && !"$root".equals(this.name)) {
            LOG.tracef("Resolve {#%s} started:%s", (Object)this.name, (Object)this.origin);
            return this.helper.resolve(new SectionResolutionContextImpl(context, params)).thenApply(r -> {
                LOG.tracef("Resolve {#%s} completed:%s", (Object)this.name, (Object)this.origin);
                return r;
            });
        }
        return this.helper.resolve(new SectionResolutionContextImpl(context, params));
    }

    @Override
    public CompletionStage<ResultNode> resolve(ResolutionContext context) {
        return this.resolve(context, null);
    }

    @Override
    public TemplateNode.Origin getOrigin() {
        return this.origin;
    }

    @Override
    public boolean isSection() {
        return true;
    }

    void optimizeNodes(Set<TemplateNode> nodes) {
        for (SectionBlock block : this.blocks) {
            block.optimizeNodes(nodes);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SectionNode [helper=").append(this.helper.getClass().getSimpleName()).append(", origin= ").append(this.origin).append("]");
        return builder.toString();
    }

    @Override
    public List<Expression> getExpressions() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (SectionBlock block : this.blocks) {
            expressions.addAll(block.getExpressions());
        }
        return expressions;
    }

    public Expression findExpression(Predicate<Expression> predicate) {
        for (SectionBlock block : this.blocks) {
            Expression found = block.findExpression(predicate);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public List<ParameterDeclaration> getParameterDeclarations() {
        List<ParameterDeclaration> declarations = null;
        for (SectionBlock block : this.blocks) {
            List<ParameterDeclaration> blockDeclarations = block.getParamDeclarations();
            if (blockDeclarations.isEmpty()) continue;
            if (declarations == null) {
                declarations = new ArrayList<ParameterDeclaration>();
            }
            declarations.addAll(blockDeclarations);
        }
        return declarations != null ? declarations : Collections.emptyList();
    }

    TemplateNode findNode(Predicate<TemplateNode> predicate) {
        for (SectionBlock block : this.blocks) {
            TemplateNode found = block.findNode(predicate);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    List<TemplateNode> findNodes(Predicate<TemplateNode> predicate) {
        ArrayList<TemplateNode> ret = null;
        for (SectionBlock block : this.blocks) {
            List<TemplateNode> found = block.findNodes(predicate);
            if (found.isEmpty()) continue;
            if (ret == null) {
                ret = new ArrayList<TemplateNode>();
            }
            ret.addAll(found);
        }
        return ret == null ? Collections.emptyList() : ret;
    }

    class SectionResolutionContextImpl
    implements SectionHelper.SectionResolutionContext {
        private final Map<String, Object> params;
        private final ResolutionContext resolutionContext;

        public SectionResolutionContextImpl(ResolutionContext resolutionContext, Map<String, Object> params) {
            this.resolutionContext = resolutionContext;
            this.params = params;
        }

        @Override
        public CompletionStage<ResultNode> execute(SectionBlock block, ResolutionContext context) {
            int size;
            if (block == null) {
                block = SectionNode.this.blocks.get(0);
            }
            if ((size = block.nodes.size()) == 1) {
                return block.nodes.get(0).resolve(context);
            }
            ArrayList<CompletionStage<ResultNode>> results = new ArrayList<CompletionStage<ResultNode>>(size);
            for (TemplateNode node : block.nodes) {
                results.add(node.resolve(context));
            }
            return Results.process(results);
        }

        @Override
        public ResolutionContext resolutionContext() {
            return this.resolutionContext;
        }

        @Override
        public ResolutionContext newResolutionContext(Object data, Map<String, SectionBlock> extendingBlocks) {
            return new ResolutionContextImpl(data, this.resolutionContext.getEvaluator(), extendingBlocks, this.resolutionContext::getAttribute);
        }

        @Override
        public Map<String, Object> getParameters() {
            return this.params;
        }
    }

    static class Builder {
        final String helperName;
        final TemplateNode.Origin origin;
        private final List<SectionBlock.Builder> blocks;
        private SectionBlock.Builder currentBlock;
        SectionHelperFactory<?> factory;
        private EngineImpl engine;
        private final ErrorInitializer errorInitializer;

        Builder(String helperName, TemplateNode.Origin origin, Parser parser, ErrorInitializer errorInitializer) {
            this.helperName = helperName;
            this.origin = origin;
            this.blocks = new ArrayList<SectionBlock.Builder>();
            this.errorInitializer = errorInitializer;
            this.addBlock(SectionBlock.builder("$main", parser, errorInitializer).setOrigin(origin));
        }

        Builder addBlock(SectionBlock.Builder block) {
            this.blocks.add(block);
            this.currentBlock = block;
            return this;
        }

        Builder endBlock() {
            this.currentBlock = this.blocks.get(0);
            return this;
        }

        SectionBlock.Builder currentBlock() {
            return this.currentBlock;
        }

        Builder setHelperFactory(SectionHelperFactory<?> factory) {
            this.factory = factory;
            return this;
        }

        Builder setEngine(EngineImpl engine) {
            this.engine = engine;
            return this;
        }

        SectionNode build(Supplier<Template> currentTemlate) {
            ImmutableList.Builder<SectionBlock> builder = ImmutableList.builder();
            for (SectionBlock.Builder block : this.blocks) {
                builder.add(block.build());
            }
            List<SectionBlock> blocks = builder.build();
            return new SectionNode(this.helperName, blocks, (SectionHelper)this.factory.initialize(new SectionInitContextImpl(this.engine, blocks, this.errorInitializer, currentTemlate)), this.origin);
        }
    }
}

