/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;

public class RequestMethodAttribute
implements ExchangeAttribute {
    public static final String REQUEST_METHOD_SHORT = "%m";
    public static final String REQUEST_METHOD = "%{METHOD}";
    public static final ExchangeAttribute INSTANCE = new RequestMethodAttribute();

    private RequestMethodAttribute() {
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        return exchange.request().method().name();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Request method", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request method";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RequestMethodAttribute.REQUEST_METHOD) || token.equals(RequestMethodAttribute.REQUEST_METHOD_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

