/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.quarkus.vertx.http.runtime.logstream.JsonFormatter;
import io.vertx.core.http.ServerWebSocket;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class WebSocketHandler
extends ExtHandler {
    private final ServerWebSocket session;

    public WebSocketHandler(ServerWebSocket session) {
        this.session = session;
        this.setFormatter((Formatter)((Object)new JsonFormatter()));
    }

    public final void doPublish(ExtLogRecord record) {
        if (record.getMessage() == null || record.getMessage().isEmpty()) {
            return;
        }
        if (this.session != null && this.isLoggable((LogRecord)record)) {
            String message = this.getFormatter().format((LogRecord)record);
            try {
                this.session.writeTextMessage(message);
            }
            catch (Throwable ex) {
                this.session.close();
            }
        }
    }
}

