/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.deployment.ResteasyJaxrsConfigBuildItem;
import io.quarkus.resteasy.runtime.ExceptionMapperRecorder;
import io.quarkus.resteasy.runtime.ResteasyFilter;
import io.quarkus.resteasy.server.common.deployment.ResteasyServerConfigBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyServletMappingBuildItem;
import io.quarkus.undertow.deployment.FilterBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.quarkus.undertow.deployment.ServletContextPathBuildItem;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import io.quarkus.undertow.deployment.WebMetadataBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.ws.rs.core.Application;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.resteasy.microprofile.config.FilterConfigSourceImpl;
import org.jboss.resteasy.microprofile.config.ServletConfigSourceImpl;
import org.jboss.resteasy.microprofile.config.ServletContextConfigSourceImpl;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;

public class ResteasyServletProcessor {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.resteasy");
    private static final String JAVAX_WS_RS_APPLICATION;
    private static final String JAX_RS_FILTER_NAME;
    private static final String JAX_RS_SERVLET_NAME;

    @BuildStep
    public void jaxrsConfig(Optional<ResteasyServerConfigBuildItem> resteasyServerConfig, BuildProducer<ResteasyJaxrsConfigBuildItem> resteasyJaxrsConfig, HttpRootPathBuildItem httpRootPathBuildItem) {
        if (resteasyServerConfig.isPresent()) {
            resteasyJaxrsConfig.produce((BuildItem)new ResteasyJaxrsConfigBuildItem(httpRootPathBuildItem.adjustPath(resteasyServerConfig.get().getPath())));
        }
    }

    @BuildStep
    public ResteasyServletMappingBuildItem webXmlMapping(Optional<WebMetadataBuildItem> webMetadataBuildItem) {
        List servletMappings;
        if (webMetadataBuildItem.isPresent() && (servletMappings = webMetadataBuildItem.get().getWebMetaData().getServletMappings()) != null) {
            for (ServletMappingMetaData mapping : servletMappings) {
                if (!JAVAX_WS_RS_APPLICATION.equals(mapping.getServletName()) || mapping.getUrlPatterns().isEmpty()) continue;
                return new ResteasyServletMappingBuildItem((String)mapping.getUrlPatterns().iterator().next());
            }
        }
        return null;
    }

    @BuildStep
    public void build(Capabilities capabilities, Optional<ResteasyServerConfigBuildItem> resteasyServerConfig, BuildProducer<FeatureBuildItem> feature, BuildProducer<FilterBuildItem> filter, BuildProducer<ServletBuildItem> servlet, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServletInitParamBuildItem> servletInitParameters, Optional<ServletContextPathBuildItem> servletContextPathBuildItem, ResteasyInjectionReadyBuildItem resteasyInjectionReady) throws Exception {
        if (!capabilities.isPresent(Capability.SERVLET)) {
            return;
        }
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY));
        if (resteasyServerConfig.isPresent()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{ServletConfigSourceImpl.class, ServletContextConfigSourceImpl.class, FilterConfigSourceImpl.class}));
            String path = resteasyServerConfig.get().getPath();
            if (path.equals("/") || path.isEmpty()) {
                filter.produce((BuildItem)FilterBuildItem.builder((String)JAX_RS_FILTER_NAME, (String)ResteasyFilter.class.getName()).setLoadOnStartup(1).addFilterServletNameMapping("default", DispatcherType.REQUEST).addFilterServletNameMapping("default", DispatcherType.FORWARD).addFilterServletNameMapping("default", DispatcherType.INCLUDE).setAsyncSupported(true).build());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ResteasyFilter.class.getName()}));
            } else {
                String mappingPath = this.getMappingPath(path);
                servlet.produce((BuildItem)ServletBuildItem.builder((String)JAX_RS_SERVLET_NAME, (String)HttpServlet30Dispatcher.class.getName()).setLoadOnStartup(1).addMapping(mappingPath).setAsyncSupported(true).build());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{HttpServlet30Dispatcher.class.getName()}));
            }
            for (Map.Entry initParameter : resteasyServerConfig.get().getInitParameters().entrySet()) {
                servletInitParameters.produce((BuildItem)new ServletInitParamBuildItem((String)initParameter.getKey(), (String)initParameter.getValue()));
            }
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void addServletsToExceptionMapper(List<ServletBuildItem> servlets, ExceptionMapperRecorder recorder) {
        recorder.setServlets(servlets.stream().filter(s -> !JAX_RS_SERVLET_NAME.equals(s.getName())).collect(Collectors.toMap(s -> s.getName(), s -> s.getMappings())));
    }

    private String getMappingPath(String path) {
        if (path.endsWith("/*")) {
            return path;
        }
        String mappingPath = path.endsWith("/") ? path + "*" : path + "/*";
        return mappingPath;
    }

    static {
        JAX_RS_FILTER_NAME = JAVAX_WS_RS_APPLICATION = Application.class.getName();
        JAX_RS_SERVLET_NAME = JAVAX_WS_RS_APPLICATION;
    }
}

