/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jackson.deployment;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.jackson.ObjectMapperProducer;
import io.quarkus.jackson.deployment.IgnoreJsonDeserializeClassBuildItem;
import io.quarkus.jackson.spi.ClassPathJacksonModuleBuildItem;
import io.quarkus.jackson.spi.JacksonModuleBuildItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class JacksonProcessor {
    private static final DotName JSON_DESERIALIZE = DotName.createSimple((String)JsonDeserialize.class.getName());
    private static final DotName JSON_SERIALIZE = DotName.createSimple((String)JsonSerialize.class.getName());
    private static final DotName JSON_CREATOR = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonCreator");
    private static final DotName JSON_NAMING = DotName.createSimple((String)"com.fasterxml.jackson.databind.annotation.JsonNaming");
    private static final DotName BUILDER_VOID = DotName.createSimple((String)Void.class.getName());
    private static final String TIME_MODULE = "com.fasterxml.jackson.datatype.jsr310.JavaTimeModule";
    private static final String JDK8_MODULE = "com.fasterxml.jackson.datatype.jdk8.Jdk8Module";
    private static final String PARAMETER_NAMES_MODULE = "com.fasterxml.jackson.module.paramnames.ParameterNamesModule";
    private static final List<String> MODULES_NAMES_TO_AUTO_REGISTER = Arrays.asList("com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", "com.fasterxml.jackson.datatype.jdk8.Jdk8Module", "com.fasterxml.jackson.module.paramnames.ParameterNamesModule");
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;
    @Inject
    List<IgnoreJsonDeserializeClassBuildItem> ignoreJsonDeserializeClassBuildItems;

    @BuildStep
    CapabilityBuildItem register(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethod, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector", "com.fasterxml.jackson.databind.ser.std.SqlDateSerializer", "com.fasterxml.jackson.databind.ser.std.SqlTimeSerializer"}));
        IndexView index = this.combinedIndexBuildItem.getIndex();
        HashSet<DotName> ignoredDotNames = new HashSet<DotName>();
        for (IgnoreJsonDeserializeClassBuildItem ignoreJsonDeserializeClassBuildItem : this.ignoreJsonDeserializeClassBuildItems) {
            ignoredDotNames.add(ignoreJsonDeserializeClassBuildItem.getDotName());
        }
        for (AnnotationInstance deserializeInstance : index.getAnnotations(JSON_DESERIALIZE)) {
            AnnotationValue usingValue;
            AnnotationTarget annotationTarget = deserializeInstance.target();
            if (AnnotationTarget.Kind.CLASS.equals((Object)annotationTarget.kind())) {
                DotName builderClassName;
                AnnotationValue annotationValue;
                DotName dotName = annotationTarget.asClass().name();
                if (!ignoredDotNames.contains(dotName)) {
                    this.addReflectiveHierarchyClass(dotName, reflectiveHierarchyClass);
                }
                if (null != (annotationValue = deserializeInstance.value("builder")) && AnnotationValue.Kind.CLASS.equals((Object)annotationValue.kind()) && !BUILDER_VOID.equals((Object)(builderClassName = annotationValue.asClass().name()))) {
                    this.addReflectiveHierarchyClass(builderClassName, reflectiveHierarchyClass);
                }
            }
            if ((usingValue = deserializeInstance.value("using")) == null) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{usingValue.asClass().name().toString()}));
        }
        for (AnnotationInstance serializeInstance : index.getAnnotations(JSON_SERIALIZE)) {
            AnnotationValue usingValue = serializeInstance.value("using");
            if (usingValue == null) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{usingValue.asClass().name().toString()}));
        }
        for (AnnotationInstance creatorInstance : index.getAnnotations(JSON_CREATOR)) {
            if (AnnotationTarget.Kind.METHOD != creatorInstance.target().kind()) continue;
            reflectiveMethod.produce((BuildItem)new ReflectiveMethodBuildItem(creatorInstance.target().asMethod()));
        }
        for (AnnotationInstance jsonNamingInstance : index.getAnnotations(JSON_NAMING)) {
            AnnotationValue strategyValue = jsonNamingInstance.value("value");
            if (strategyValue == null) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{strategyValue.asClass().name().toString()}));
        }
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ObjectMapperProducer.class}));
        return new CapabilityBuildItem(Capability.JACKSON);
    }

    private void addReflectiveHierarchyClass(DotName className, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass) {
        Type jandexType = Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS);
        reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(jandexType).source(this.getClass().getSimpleName() + " > " + jandexType.name().toString()).build());
    }

    @BuildStep
    void autoRegisterModules(BuildProducer<ClassPathJacksonModuleBuildItem> classPathJacksonModules) {
        for (String module : MODULES_NAMES_TO_AUTO_REGISTER) {
            this.registerModuleIfOnClassPath(module, classPathJacksonModules);
        }
    }

    private void registerModuleIfOnClassPath(String moduleClassName, BuildProducer<ClassPathJacksonModuleBuildItem> classPathJacksonModules) {
        try {
            Class.forName(moduleClassName, false, Thread.currentThread().getContextClassLoader());
            classPathJacksonModules.produce((BuildItem)new ClassPathJacksonModuleBuildItem(moduleClassName));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @BuildStep
    void generateCustomizer(BuildProducer<GeneratedBeanBuildItem> generatedBeans, List<JacksonModuleBuildItem> jacksonModules, List<ClassPathJacksonModuleBuildItem> classPathJacksonModules) {
        if (jacksonModules.isEmpty() && classPathJacksonModules.isEmpty()) {
            return;
        }
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className("io.quarkus.jackson.customizer.RegisterSerializersAndDeserializersCustomizer").interfaces(new String[]{ObjectMapperCustomizer.class.getName()}).build();){
            classCreator.addAnnotation(Singleton.class);
            try (MethodCreator customize = classCreator.getMethodCreator("customize", Void.TYPE, new Class[]{ObjectMapper.class});){
                ResultHandle module;
                ResultHandle objectMapper = customize.getMethodParam(0);
                for (JacksonModuleBuildItem jacksonModule : jacksonModules) {
                    if (jacksonModule.getItems().isEmpty()) continue;
                    module = customize.newInstance(MethodDescriptor.ofConstructor(SimpleModule.class, (Class[])new Class[]{String.class}), new ResultHandle[]{customize.load(jacksonModule.getName())});
                    for (JacksonModuleBuildItem.Item item : jacksonModule.getItems()) {
                        String deserializerClassName;
                        ResultHandle targetClass = customize.loadClass(item.getTargetClassName());
                        String serializerClassName = item.getSerializerClassName();
                        if (serializerClassName != null && !serializerClassName.isEmpty()) {
                            ResultHandle serializer = customize.newInstance(MethodDescriptor.ofConstructor((String)serializerClassName, (String[])new String[0]), new ResultHandle[0]);
                            customize.invokeVirtualMethod(MethodDescriptor.ofMethod(SimpleModule.class, (String)"addSerializer", SimpleModule.class, (Class[])new Class[]{Class.class, JsonSerializer.class}), module, new ResultHandle[]{targetClass, serializer});
                        }
                        if ((deserializerClassName = item.getDeserializerClassName()) == null || deserializerClassName.isEmpty()) continue;
                        ResultHandle deserializer = customize.newInstance(MethodDescriptor.ofConstructor((String)deserializerClassName, (String[])new String[0]), new ResultHandle[0]);
                        customize.invokeVirtualMethod(MethodDescriptor.ofMethod(SimpleModule.class, (String)"addDeserializer", SimpleModule.class, (Class[])new Class[]{Class.class, JsonDeserializer.class}), module, new ResultHandle[]{targetClass, deserializer});
                    }
                    customize.invokeVirtualMethod(MethodDescriptor.ofMethod(ObjectMapper.class, (String)"registerModule", ObjectMapper.class, (Class[])new Class[]{Module.class}), objectMapper, new ResultHandle[]{module});
                }
                for (ClassPathJacksonModuleBuildItem classPathJacksonModule : classPathJacksonModules) {
                    module = customize.newInstance(MethodDescriptor.ofConstructor((String)classPathJacksonModule.getModuleClassName(), (String[])new String[0]), new ResultHandle[0]);
                    customize.invokeVirtualMethod(MethodDescriptor.ofMethod(ObjectMapper.class, (String)"registerModule", ObjectMapper.class, (Class[])new Class[]{Module.class}), objectMapper, new ResultHandle[]{module});
                }
                customize.returnValue(null);
            }
            var8_10 = null;
            try (MethodCreator priority = classCreator.getMethodCreator("priority", Integer.TYPE, new Class[0]);){
                priority.returnValue(priority.load(Integer.MIN_VALUE));
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
        }
    }
}

