/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.formatter;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import io.quarkus.annotation.processor.documentation.config.model.JavadocFormat;
import java.util.regex.Pattern;

public class JavadocToMarkdownTransformer {
    private static final Pattern START_OF_LINE = Pattern.compile("^", 8);

    public static String toMarkdown(String javadoc, JavadocFormat format) {
        if (javadoc == null || javadoc.isBlank()) {
            return null;
        }
        if (format == JavadocFormat.MARKDOWN) {
            return javadoc;
        }
        if (format == JavadocFormat.JAVADOC) {
            Javadoc parsedJavadoc = StaticJavaParser.parseJavadoc((String)START_OF_LINE.matcher(javadoc).replaceAll("* "));
            return JavadocToMarkdownTransformer.simplifyJavadoc(parsedJavadoc.getDescription());
        }
        return "";
    }

    private static String simplifyJavadoc(JavadocDescription javadocDescription) {
        StringBuilder sb = new StringBuilder();
        for (JavadocDescriptionElement javadocDescriptionElement : javadocDescription.getElements()) {
            if (javadocDescriptionElement instanceof JavadocInlineTag) {
                JavadocInlineTag inlineTag = (JavadocInlineTag)javadocDescriptionElement;
                String content = inlineTag.getContent().trim();
                switch (inlineTag.getType()) {
                    case CODE: 
                    case VALUE: 
                    case LITERAL: 
                    case SYSTEM_PROPERTY: 
                    case LINK: 
                    case LINKPLAIN: {
                        sb.append("<code>");
                        sb.append(JavadocToMarkdownTransformer.escapeHtml(content));
                        sb.append("</code>");
                        break;
                    }
                    default: {
                        sb.append(content);
                        break;
                    }
                }
                continue;
            }
            sb.append(javadocDescriptionElement.toText());
        }
        return sb.toString().trim();
    }

    private static String escapeHtml(String s) {
        StringBuilder out = new StringBuilder(Math.max(16, s.length()));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '\'' || c == '<' || c == '>' || c == '&') {
                out.append("&#");
                out.append((int)c);
                out.append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }
}

