/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.StreamCoords;
import io.quarkus.registry.ExclusiveProviderConflictException;
import io.quarkus.registry.PlatformStackIndex;
import io.quarkus.registry.RegistryExtensionResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.catalog.json.JsonCatalogMerger;
import io.quarkus.registry.catalog.json.JsonPlatformCatalog;
import io.quarkus.registry.client.RegistryClientFactory;
import io.quarkus.registry.client.maven.MavenRegistryClientFactory;
import io.quarkus.registry.client.spi.RegistryClientEnvironment;
import io.quarkus.registry.client.spi.RegistryClientFactoryProvider;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistriesConfigLocator;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.union.ElementCatalogBuilder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class ExtensionCatalogResolver {
    private MessageWriter log;
    private List<RegistryExtensionResolver> registries;

    public static ExtensionCatalogResolver empty() {
        ExtensionCatalogResolver resolver = new ExtensionCatalogResolver();
        resolver.registries = Collections.emptyList();
        return resolver;
    }

    public static Builder builder() {
        return new ExtensionCatalogResolver().new Builder();
    }

    public boolean hasRegistries() {
        return !this.registries.isEmpty();
    }

    public PlatformCatalog resolvePlatformCatalog() throws RegistryResolutionException {
        return this.resolvePlatformCatalog(null);
    }

    public PlatformCatalog resolvePlatformCatalog(String quarkusVersion) throws RegistryResolutionException {
        ArrayList<PlatformCatalog> catalogs = new ArrayList<PlatformCatalog>(this.registries.size());
        for (RegistryExtensionResolver qer : this.registries) {
            PlatformCatalog catalog = qer.resolvePlatformCatalog(quarkusVersion);
            if (catalog == null) continue;
            catalogs.add(catalog);
        }
        if (catalogs.isEmpty()) {
            return null;
        }
        if (catalogs.size() == 1) {
            return (PlatformCatalog)catalogs.get(0);
        }
        JsonPlatformCatalog result = new JsonPlatformCatalog();
        ArrayList<Platform> collectedPlatforms = new ArrayList<Platform>();
        result.setPlatforms(collectedPlatforms);
        HashSet<String> collectedPlatformKeys = new HashSet<String>();
        for (PlatformCatalog c : catalogs) {
            this.collectPlatforms(c, collectedPlatforms, collectedPlatformKeys);
        }
        return result;
    }

    private void collectPlatforms(PlatformCatalog catalog, List<Platform> collectedPlatforms, Set<String> collectedPlatformKeys) {
        for (Platform p : catalog.getPlatforms()) {
            if (!collectedPlatformKeys.add(p.getPlatformKey())) continue;
            collectedPlatforms.add(p);
        }
    }

    public ExtensionCatalog resolveExtensionCatalog() throws RegistryResolutionException {
        this.ensureRegistriesConfigured();
        ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>();
        ElementCatalogBuilder catalogBuilder = ElementCatalogBuilder.newInstance();
        int platformIndex = 0;
        for (RegistryExtensionResolver registry : this.registries) {
            PlatformCatalog pc = registry.resolvePlatformCatalog();
            if (pc == null) continue;
            for (Platform platform : pc.getPlatforms()) {
                ++platformIndex;
                int streamIndex = 0;
                for (PlatformStream stream : platform.getStreams()) {
                    ++streamIndex;
                    int releaseIndex = 0;
                    for (PlatformRelease release : stream.getReleases()) {
                        ElementCatalogBuilder.UnionBuilder<ExtensionCatalog> union = catalogBuilder.getOrCreateUnion(new PlatformStackIndex(platformIndex, streamIndex, ++releaseIndex));
                        for (ArtifactCoords bom : release.getMemberBoms()) {
                            ExtensionCatalog ec = registry.resolvePlatformExtensions(bom);
                            if (ec != null) {
                                catalogs.add(ec);
                                ElementCatalogBuilder.addUnionMember(union, ec);
                                continue;
                            }
                            this.log.warn("Failed to resolve extension catalog for %s from registry %s", new Object[]{bom, registry.getId()});
                        }
                        HashMap<String, List<RegistryExtensionResolver>> registriesByQuarkusCore = new HashMap<String, List<RegistryExtensionResolver>>(2);
                        registriesByQuarkusCore.put(release.getQuarkusCoreVersion(), this.getRegistriesForQuarkusVersion(release.getQuarkusCoreVersion()));
                        String upstreamQuarkusVersion = release.getUpstreamQuarkusCoreVersion();
                        if (upstreamQuarkusVersion != null && !registriesByQuarkusCore.containsKey(upstreamQuarkusVersion)) {
                            registriesByQuarkusCore.put(upstreamQuarkusVersion, this.getRegistriesForQuarkusVersion(upstreamQuarkusVersion));
                        }
                        this.appendNonPlatformExtensions(registriesByQuarkusCore, union, catalogs);
                    }
                }
            }
        }
        ExtensionCatalog catalog = JsonCatalogMerger.merge(catalogs);
        ElementCatalogBuilder.setElementCatalog(catalog, catalogBuilder.build());
        return catalog;
    }

    public ExtensionCatalog resolveExtensionCatalog(String quarkusCoreVersion) throws RegistryResolutionException {
        int registriesTotal = this.registries.size();
        if (registriesTotal == 0) {
            throw new RegistryResolutionException("No registries configured");
        }
        LinkedHashMap<String, List<RegistryExtensionResolver>> registriesByQuarkusCore = new LinkedHashMap<String, List<RegistryExtensionResolver>>(registriesTotal);
        ArrayList<ExtensionCatalog> extensionCatalogs = null;
        if (quarkusCoreVersion == null) {
            if (registriesTotal == 1) {
                Platform recommendedPlatform;
                PlatformCatalog platformCatalog = this.registries.get(0).resolvePlatformCatalog();
                Platform platform = recommendedPlatform = platformCatalog == null ? null : platformCatalog.getRecommendedPlatform();
                if (recommendedPlatform == null) {
                    throw new RegistryResolutionException("Registry " + this.registries.get(0).getId() + " does not provide any platform");
                }
                PlatformRelease release = recommendedPlatform.getRecommendedStream().getRecommendedRelease();
                ArrayList<PlatformRelease> recommendedReleases = new ArrayList<PlatformRelease>(1);
                recommendedReleases.add(release);
                String commonQuarkusVersion = quarkusCoreVersion = release.getQuarkusCoreVersion();
                int i = 1;
                Iterator<Platform> platformsIterator = platformCatalog.getPlatforms().iterator();
                if (platformsIterator.hasNext()) {
                    platformsIterator.next();
                }
                block0: while (platformsIterator.hasNext() && commonQuarkusVersion != null) {
                    Platform p = platformsIterator.next();
                    for (PlatformStream s : p.getStreams()) {
                        for (PlatformRelease r : s.getReleases()) {
                            if (!r.getQuarkusCoreVersion().equals(commonQuarkusVersion)) {
                                commonQuarkusVersion = null;
                                break;
                            }
                            recommendedReleases.add(r);
                        }
                        if (commonQuarkusVersion != null) continue;
                        continue block0;
                    }
                }
                if (commonQuarkusVersion != null) {
                    RegistryExtensionResolver mainRegistry = this.registries.get(0);
                    registriesByQuarkusCore.put(commonQuarkusVersion, Arrays.asList(mainRegistry));
                    extensionCatalogs = new ArrayList();
                    i = 0;
                    while (i < recommendedReleases.size()) {
                        for (ArtifactCoords bom : ((PlatformRelease)recommendedReleases.get(i++)).getMemberBoms()) {
                            extensionCatalogs.add(mainRegistry.resolvePlatformExtensions(bom));
                        }
                    }
                }
            } else {
                quarkusCoreVersion = this.registries.get(0).resolveRecommendedPlatform().getRecommendedStream().getRecommendedRelease().getQuarkusCoreVersion();
            }
        }
        if (extensionCatalogs == null) {
            extensionCatalogs = new ArrayList<ExtensionCatalog>();
            HashSet<String> upstreamQuarkusVersions = new HashSet<String>(1);
            this.collectPlatforms(quarkusCoreVersion, registriesByQuarkusCore, upstreamQuarkusVersions, extensionCatalogs);
            if (!upstreamQuarkusVersions.isEmpty()) {
                HashSet<String> upstreamToProcess = upstreamQuarkusVersions;
                HashSet<String> collectedUpstream = new HashSet<String>(0);
                do {
                    collectedUpstream.clear();
                    Iterator upstreamIterator = upstreamToProcess.iterator();
                    while (upstreamIterator.hasNext()) {
                        this.collectPlatforms((String)upstreamIterator.next(), registriesByQuarkusCore, collectedUpstream, extensionCatalogs);
                    }
                    HashSet<String> tmp = upstreamToProcess;
                    upstreamToProcess = collectedUpstream;
                    collectedUpstream = tmp;
                } while (!upstreamToProcess.isEmpty());
            }
        }
        this.appendNonPlatformExtensions(registriesByQuarkusCore, null, extensionCatalogs);
        return JsonCatalogMerger.merge(extensionCatalogs);
    }

    public ExtensionCatalog resolveExtensionCatalog(StreamCoords streamCoords) throws RegistryResolutionException {
        this.ensureRegistriesConfigured();
        ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>();
        ElementCatalogBuilder catalogBuilder = ElementCatalogBuilder.newInstance();
        String platformKey = streamCoords.getPlatformKey();
        String streamId = streamCoords.getStreamId();
        PlatformStream stream = null;
        RegistryExtensionResolver registry = null;
        block0: for (RegistryExtensionResolver qer : this.registries) {
            PlatformCatalog platforms = qer.resolvePlatformCatalog();
            if (platforms == null) continue;
            if (platformKey == null) {
                for (Platform p : platforms.getPlatforms()) {
                    stream = p.getStream(streamId);
                    if (stream == null) continue;
                    registry = qer;
                    break block0;
                }
                break;
            }
            Platform platform = platforms.getPlatform(platformKey);
            if (platform == null) continue;
            stream = platform.getStream(streamId);
            registry = qer;
            break;
        }
        if (stream == null) {
            Platform requestedPlatform = null;
            ArrayList<Platform> knownPlatforms = new ArrayList<Platform>();
            for (RegistryExtensionResolver qer : this.registries) {
                PlatformCatalog platforms = qer.resolvePlatformCatalog();
                if (platforms == null) continue;
                if (platformKey != null && (requestedPlatform = platforms.getPlatform(platformKey)) != null) break;
                for (Platform platform : platforms.getPlatforms()) {
                    knownPlatforms.add(platform);
                }
            }
            StringBuilder buf = new StringBuilder();
            if (requestedPlatform != null) {
                buf.append("Failed to locate stream ").append(streamId).append(" in platform " + requestedPlatform.getPlatformKey());
            } else if (knownPlatforms.isEmpty()) {
                buf.append("None of the registries provided any platform");
            } else {
                if (platformKey == null) {
                    buf.append("Failed to locate stream ").append(streamId).append(" in platform(s): ");
                } else {
                    buf.append("Failed to locate platform ").append(platformKey).append(" among available platform(s): ");
                }
                buf.append(((Platform)knownPlatforms.get(0)).getPlatformKey());
                for (int i = 1; i < knownPlatforms.size(); ++i) {
                    buf.append(", ").append(((Platform)knownPlatforms.get(i)).getPlatformKey());
                }
            }
            throw new RegistryResolutionException(buf.toString());
        }
        PlatformRelease release = stream.getRecommendedRelease();
        ElementCatalogBuilder.UnionBuilder<ExtensionCatalog> union = catalogBuilder.getOrCreateUnion(PlatformStackIndex.initial());
        for (ArtifactCoords bom : release.getMemberBoms()) {
            ExtensionCatalog ec = registry.resolvePlatformExtensions(bom);
            catalogs.add(ec);
            ElementCatalogBuilder.addUnionMember(union, ec);
        }
        HashMap<String, List<RegistryExtensionResolver>> registriesByQuarkusCore = new HashMap<String, List<RegistryExtensionResolver>>(2);
        registriesByQuarkusCore.put(release.getQuarkusCoreVersion(), this.getRegistriesForQuarkusVersion(release.getQuarkusCoreVersion()));
        String upstreamQuarkusVersion = release.getUpstreamQuarkusCoreVersion();
        if (upstreamQuarkusVersion != null && !registriesByQuarkusCore.containsKey(upstreamQuarkusVersion)) {
            registriesByQuarkusCore.put(upstreamQuarkusVersion, this.getRegistriesForQuarkusVersion(upstreamQuarkusVersion));
        }
        this.appendNonPlatformExtensions(registriesByQuarkusCore, union, catalogs);
        ExtensionCatalog catalog = JsonCatalogMerger.merge(catalogs);
        ElementCatalogBuilder.setElementCatalog(catalog, catalogBuilder.build());
        return catalog;
    }

    private void ensureRegistriesConfigured() throws RegistryResolutionException {
        int registriesTotal = this.registries.size();
        if (registriesTotal == 0) {
            throw new RegistryResolutionException("No registries configured");
        }
    }

    public ExtensionCatalog resolveExtensionCatalog(Collection<ArtifactCoords> platforms) throws RegistryResolutionException {
        if (platforms.isEmpty()) {
            return this.resolveExtensionCatalog();
        }
        ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>(platforms.size() + this.registries.size());
        HashMap<String, List<RegistryExtensionResolver>> registriesByQuarkusCore = new HashMap<String, List<RegistryExtensionResolver>>(2);
        String quarkusVersion = null;
        for (ArtifactCoords bom : platforms) {
            String upstreamQuarkusVersion;
            List<RegistryExtensionResolver> registries;
            try {
                registries = this.filterRegistries(r -> r.checkPlatform(bom));
            }
            catch (ExclusiveProviderConflictException e) {
                StringBuilder buf = new StringBuilder();
                buf.append("The following registries were configured as exclusive providers of the ");
                buf.append(bom);
                buf.append("platform: ").append(e.conflictingRegistries.get(0).getId());
                for (int i = 1; i < e.conflictingRegistries.size(); ++i) {
                    buf.append(", ").append(e.conflictingRegistries.get(i).getId());
                }
                throw new RuntimeException(buf.toString());
            }
            ExtensionCatalog catalog = this.resolvePlatformExtensions(bom, registries);
            if (catalog == null) continue;
            catalogs.add(catalog);
            if (quarkusVersion == null) {
                quarkusVersion = catalog.getQuarkusCoreVersion();
                registriesByQuarkusCore.put(quarkusVersion, this.getRegistriesForQuarkusVersion(quarkusVersion));
            }
            if ((upstreamQuarkusVersion = catalog.getUpstreamQuarkusCoreVersion()) == null || registriesByQuarkusCore.containsKey(upstreamQuarkusVersion)) continue;
            registriesByQuarkusCore.put(upstreamQuarkusVersion, this.getRegistriesForQuarkusVersion(upstreamQuarkusVersion));
        }
        this.appendNonPlatformExtensions(registriesByQuarkusCore, null, catalogs);
        return JsonCatalogMerger.merge(catalogs);
    }

    private ExtensionCatalog resolvePlatformExtensions(ArtifactCoords bom, List<RegistryExtensionResolver> registries) {
        if (registries.isEmpty()) {
            this.log.debug("None of the configured registries recognizes platform %s", new Object[]{bom});
            return null;
        }
        for (RegistryExtensionResolver registry : registries) {
            try {
                return registry.resolvePlatformExtensions(bom);
            }
            catch (RegistryResolutionException registryResolutionException) {
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to resolve platform ").append(bom).append(" using the following registries: ");
        buf.append(registries.get(0).getId());
        for (int i = 1; i < registries.size(); ++i) {
            buf.append(", ").append(registries.get(i++));
        }
        this.log.warn(buf.toString());
        return null;
    }

    private void appendNonPlatformExtensions(Map<String, List<RegistryExtensionResolver>> registriesByQuarkusCore, ElementCatalogBuilder.UnionBuilder<ExtensionCatalog> union, List<ExtensionCatalog> extensionCatalogs) throws RegistryResolutionException {
        for (Map.Entry<String, List<RegistryExtensionResolver>> quarkusVersionRegistries : registriesByQuarkusCore.entrySet()) {
            for (RegistryExtensionResolver registry : quarkusVersionRegistries.getValue()) {
                ExtensionCatalog nonPlatformCatalog = registry.resolveNonPlatformExtensions(quarkusVersionRegistries.getKey());
                if (nonPlatformCatalog == null) continue;
                extensionCatalogs.add(nonPlatformCatalog);
                if (union == null) continue;
                ElementCatalogBuilder.UnionBuilder<ExtensionCatalog> union1 = union;
                ElementCatalogBuilder.addUnionMember(union1, nonPlatformCatalog);
            }
        }
    }

    private void collectPlatforms(String quarkusCoreVersion, Map<String, List<RegistryExtensionResolver>> registriesByQuarkusCore, Set<String> upstreamQuarkusVersions, List<ExtensionCatalog> extensionCatalogs) throws RegistryResolutionException {
        List<RegistryExtensionResolver> quarkusVersionRegistries = registriesByQuarkusCore.get(quarkusCoreVersion);
        if (quarkusVersionRegistries != null) {
            return;
        }
        quarkusVersionRegistries = this.getRegistriesForQuarkusVersion(quarkusCoreVersion);
        registriesByQuarkusCore.put(quarkusCoreVersion, quarkusVersionRegistries);
        for (RegistryExtensionResolver registry : quarkusVersionRegistries) {
            Collection<Platform> platforms;
            PlatformCatalog platformCatalog = registry.resolvePlatformCatalog(quarkusCoreVersion);
            if (platformCatalog == null || (platforms = platformCatalog.getPlatforms()).isEmpty()) continue;
            for (Platform p : platforms) {
                for (PlatformStream s : p.getStreams()) {
                    for (PlatformRelease r : s.getReleases()) {
                        String upstreamQuarkusCoreVersion = r.getUpstreamQuarkusCoreVersion();
                        if (upstreamQuarkusCoreVersion != null && !registriesByQuarkusCore.containsKey(upstreamQuarkusCoreVersion)) {
                            upstreamQuarkusVersions.add(upstreamQuarkusCoreVersion);
                        }
                        for (ArtifactCoords bom : r.getMemberBoms()) {
                            ExtensionCatalog catalog = registry.resolvePlatformExtensions(bom);
                            if (catalog == null) continue;
                            extensionCatalogs.add(catalog);
                        }
                    }
                }
            }
        }
    }

    private List<RegistryExtensionResolver> getRegistriesForQuarkusVersion(String quarkusCoreVersion) {
        try {
            return this.filterRegistries(r -> r.checkQuarkusVersion(quarkusCoreVersion));
        }
        catch (ExclusiveProviderConflictException e) {
            StringBuilder buf = new StringBuilder();
            buf.append("The following registries were configured as exclusive providers of extensions based on Quarkus version ");
            buf.append(quarkusCoreVersion);
            buf.append(": ").append(e.conflictingRegistries.get(0).getId());
            for (int i = 1; i < e.conflictingRegistries.size(); ++i) {
                buf.append(", ").append(e.conflictingRegistries.get(i).getId());
            }
            throw new RuntimeException(buf.toString());
        }
    }

    private List<RegistryExtensionResolver> filterRegistries(Function<RegistryExtensionResolver, Integer> recognizer) throws ExclusiveProviderConflictException {
        RegistryExtensionResolver exclusiveProvider = null;
        List<RegistryExtensionResolver> filtered = null;
        ArrayList<RegistryExtensionResolver> conflicts = null;
        for (int i = 0; i < this.registries.size(); ++i) {
            RegistryExtensionResolver registry = this.registries.get(i);
            int versionCheck = recognizer.apply(registry);
            if (versionCheck == -1) {
                if (exclusiveProvider != null || filtered != null) continue;
                filtered = new ArrayList<RegistryExtensionResolver>(this.registries.size() - 1);
                for (int j = 0; j < i; ++j) {
                    filtered.add(this.registries.get(j));
                }
                continue;
            }
            if (versionCheck == 2) {
                if (exclusiveProvider == null) {
                    exclusiveProvider = registry;
                } else {
                    if (conflicts == null) {
                        conflicts = new ArrayList<RegistryExtensionResolver>();
                        conflicts.add(exclusiveProvider);
                    }
                    conflicts.add(registry);
                }
            }
            if (filtered == null) continue;
            filtered.add(registry);
        }
        if (conflicts != null) {
            throw new ExclusiveProviderConflictException(conflicts);
        }
        return exclusiveProvider == null ? (filtered == null ? this.registries : filtered) : Arrays.asList(exclusiveProvider);
    }

    public class Builder {
        private MavenArtifactResolver artifactResolver;
        private RegistriesConfig config;
        private boolean built;
        private RegistryClientFactory defaultClientFactory;
        private RegistryClientEnvironment clientEnv;

        private Builder() {
        }

        public Builder artifactResolver(MavenArtifactResolver resolver) {
            this.assertNotBuilt();
            this.artifactResolver = resolver;
            return this;
        }

        public Builder messageWriter(MessageWriter messageWriter) {
            this.assertNotBuilt();
            ExtensionCatalogResolver.this.log = messageWriter;
            return this;
        }

        public Builder config(RegistriesConfig registriesConfig) {
            this.assertNotBuilt();
            this.config = registriesConfig;
            return this;
        }

        public ExtensionCatalogResolver build() {
            this.assertNotBuilt();
            this.built = true;
            this.completeConfig();
            this.buildRegistryClients();
            return ExtensionCatalogResolver.this;
        }

        private void completeConfig() {
            if (this.config == null) {
                this.config = RegistriesConfigLocator.resolveConfig();
            }
            if (ExtensionCatalogResolver.this.log == null) {
                MessageWriter messageWriter = ExtensionCatalogResolver.this.log = this.config.isDebug() ? MessageWriter.debug() : MessageWriter.info();
            }
            if (this.artifactResolver == null) {
                try {
                    this.artifactResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setWorkspaceDiscovery(false)).setArtifactTransferLogging(this.config.isDebug())).build();
                }
                catch (BootstrapMavenException e) {
                    throw new IllegalStateException("Failed to intialize the default Maven artifact resolver", e);
                }
            }
        }

        private void buildRegistryClients() {
            ExtensionCatalogResolver.this.registries = new ArrayList<RegistryExtensionResolver>(this.config.getRegistries().size());
            for (RegistryConfig config : this.config.getRegistries()) {
                if (config.isDisabled()) continue;
                RegistryClientFactory clientFactory = this.getClientFactory(config);
                try {
                    ExtensionCatalogResolver.this.registries.add(new RegistryExtensionResolver(clientFactory.buildRegistryClient(config), ExtensionCatalogResolver.this.log));
                }
                catch (RegistryResolutionException e) {
                    ExtensionCatalogResolver.this.log.debug(e.getMessage());
                }
            }
        }

        private RegistryClientFactory getClientFactory(RegistryConfig config) {
            if (config.getExtra().isEmpty()) {
                return this.getDefaultClientFactory();
            }
            Object provider = config.getExtra().get("client-factory-artifact");
            if (provider != null) {
                return this.loadFromArtifact(config, provider);
            }
            provider = config.getExtra().get("client-factory-url");
            if (provider != null) {
                URL url;
                try {
                    url = new URL((String)provider);
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Failed to translate " + provider + " to URL", e);
                }
                return this.loadFromUrl(url);
            }
            return this.getDefaultClientFactory();
        }

        public RegistryClientFactory loadFromArtifact(RegistryConfig config, Object providerValue) {
            URL url;
            File providerJar;
            ArtifactCoords providerArtifact = null;
            try {
                String providerStr = (String)providerValue;
                providerArtifact = ArtifactCoords.fromString((String)providerStr);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to process configuration of " + config.getId() + " registry: failed to cast " + providerValue + " to String", e);
            }
            try {
                providerJar = this.artifactResolver.resolve((Artifact)new DefaultArtifact(providerArtifact.getGroupId(), providerArtifact.getArtifactId(), providerArtifact.getClassifier(), providerArtifact.getType(), providerArtifact.getVersion())).getArtifact().getFile();
            }
            catch (BootstrapMavenException e) {
                throw new IllegalStateException("Failed to resolve the registry client factory provider artifact " + providerArtifact, e);
            }
            ExtensionCatalogResolver.this.log.debug("Loading registry client factory for %s from %s", new Object[]{config.getId(), providerArtifact});
            try {
                url = providerJar.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to translate " + providerJar + " to URL", e);
            }
            return this.loadFromUrl(url);
        }

        private RegistryClientFactory loadFromUrl(URL url) {
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                URLClassLoader providerCl = new URLClassLoader(new URL[]{url}, originalCl);
                Iterator<RegistryClientFactoryProvider> i = ServiceLoader.load(RegistryClientFactoryProvider.class, providerCl).iterator();
                if (!i.hasNext()) {
                    throw new Exception("Failed to locate an implementation of " + RegistryClientFactoryProvider.class.getName() + " service provider");
                }
                RegistryClientFactoryProvider provider = i.next();
                if (i.hasNext()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Found more than one registry client factory provider " + provider.getClass().getName());
                    while (i.hasNext()) {
                        buf.append(", ").append(i.next().getClass().getName());
                    }
                    throw new Exception(buf.toString());
                }
                RegistryClientFactory registryClientFactory = provider.newRegistryClientFactory(this.getClientEnv());
                return registryClientFactory;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load registry client factory from " + url, e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }

        private RegistryClientFactory getDefaultClientFactory() {
            return this.defaultClientFactory == null ? (this.defaultClientFactory = new MavenRegistryClientFactory(this.artifactResolver, ExtensionCatalogResolver.this.log)) : this.defaultClientFactory;
        }

        private RegistryClientEnvironment getClientEnv() {
            return this.clientEnv == null ? (this.clientEnv = new RegistryClientEnvironment(){

                @Override
                public MessageWriter log() {
                    return ExtensionCatalogResolver.this.log;
                }

                @Override
                public MavenArtifactResolver resolver() {
                    return Builder.this.artifactResolver;
                }
            }) : this.clientEnv;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("The builder has already built an instance");
            }
        }
    }
}

