/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.credentials;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.Map;

public interface CredentialsProvider {
    public static final String USER_PROPERTY_NAME = "user";
    public static final String PASSWORD_PROPERTY_NAME = "password";
    public static final String EXPIRATION_TIMESTAMP_PROPERTY_NAME = "expires-at";

    default public Map<String, String> getCredentials(String credentialsProviderName) {
        throw new UnsupportedOperationException("Either `getCredentials` or `getCredentialsAsync` must be implemented`");
    }

    default public Uni<Map<String, String>> getCredentialsAsync(String credentialsProviderName) {
        return Uni.createFrom().item(() -> this.getCredentials(credentialsProviderName)).runSubscriptionOn(Infrastructure.getDefaultExecutor());
    }
}

