/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.phase.augment;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.DefineClassVisibleURLClassLoader;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.builder.BuildResult;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.CuratedApplicationCreator;
import io.quarkus.creator.CuratedTask;
import io.quarkus.creator.curator.CurateOutcome;
import io.quarkus.creator.phase.augment.AugmentOutcome;
import io.quarkus.deployment.QuarkusAugmentor;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class AugmentTask
implements CuratedTask<AugmentOutcome> {
    private static final Logger log = Logger.getLogger(AugmentTask.class);
    private static final String META_INF = "META-INF";
    private final Path outputDir;
    private final Path appClassesDir;
    private final Path configDir;
    private final Properties buildSystemProperties;
    private final Consumer<ConfigBuilder> configCustomizer;

    public AugmentTask(Builder builder) {
        this.outputDir = builder.outputDir;
        this.appClassesDir = builder.appClassesDir;
        this.configDir = builder.configDir;
        this.buildSystemProperties = builder.buildSystemProperties;
        this.configCustomizer = builder.configCustomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AugmentOutcome run(CurateOutcome appState, CuratedApplicationCreator ctx) throws AppCreatorException {
        List appDeps;
        Path configDir;
        Path appClassesDir;
        if (this.outputDir != null) {
            IoUtils.mkdirs((Path)this.outputDir);
        }
        Path outputDir = this.outputDir == null ? ctx.getWorkDir() : this.outputDir;
        Path path = appClassesDir = this.appClassesDir == null ? outputDir.resolve("classes") : this.appClassesDir;
        if (!Files.exists(appClassesDir, new LinkOption[0])) {
            Path appJar = appState.getAppArtifact().getPath();
            if (appJar == null) {
                try {
                    Files.createDirectory(appClassesDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new AppCreatorException("Failed to create classes directory " + appClassesDir, e);
                }
            }
            try {
                ZipUtils.unzip((Path)appJar, (Path)appClassesDir);
            }
            catch (IOException e) {
                throw new AppCreatorException("Failed to unzip " + appJar, e);
            }
            Path metaInf = appClassesDir.resolve(META_INF);
            IoUtils.recursiveDelete((Path)metaInf.resolve("maven"));
            IoUtils.recursiveDelete((Path)metaInf.resolve("INDEX.LIST"));
            IoUtils.recursiveDelete((Path)metaInf.resolve("MANIFEST.MF"));
        }
        if (this.configDir == null) {
            configDir = appClassesDir;
        } else {
            configDir = this.configDir;
            try {
                if (Files.exists(this.configDir, new LinkOption[0]) && !Files.isSameFile(this.configDir, appClassesDir)) {
                    Files.walkFileTree(configDir, new CopyDirVisitor(configDir, appClassesDir, StandardCopyOption.REPLACE_EXISTING));
                }
            }
            catch (IOException e) {
                throw new AppCreatorException("Failed while copying files from " + configDir + " to " + appClassesDir, e);
            }
        }
        Path configPath = configDir.resolve("application.properties");
        SmallRyeConfigBuilder configBuilder = ConfigUtils.configBuilder((boolean)false);
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                configBuilder.withSources(new ConfigSource[]{new PropertiesConfigSource(configPath.toUri().toURL())});
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to convert config URL", e);
            }
        }
        if (this.configCustomizer != null) {
            this.configCustomizer.accept((ConfigBuilder)configBuilder);
        }
        SmallRyeConfig config = configBuilder.build();
        QuarkusConfigFactory.setConfig((SmallRyeConfig)config);
        ConfigProviderResolver cpr = ConfigProviderResolver.instance();
        Config existing = cpr.getConfig();
        if (existing != config) {
            cpr.releaseConfig(existing);
        }
        AppModelResolver depResolver = appState.getArtifactResolver();
        try {
            appDeps = appState.getEffectiveModel().getAllDependencies();
        }
        catch (BootstrapDependencyProcessingException e) {
            throw new AppCreatorException("Failed to resolve application build classpath", e);
        }
        URLClassLoader runnerClassLoader = null;
        try {
            BuildResult result;
            ArrayList<URL> cpUrls = new ArrayList<URL>(appDeps.size() + 1);
            cpUrls.add(appClassesDir.toUri().toURL());
            for (AppDependency appDep : appDeps) {
                Path resolvedDep = depResolver.resolve(appDep.getArtifact());
                cpUrls.add(resolvedDep.toUri().toURL());
            }
            runnerClassLoader = new DefineClassVisibleURLClassLoader(cpUrls.toArray(new URL[cpUrls.size()]), this.getClass().getClassLoader());
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(runnerClassLoader);
                QuarkusAugmentor.Builder builder = QuarkusAugmentor.builder();
                builder.setRoot(appClassesDir);
                builder.setBaseName(ctx.getBaseName());
                builder.setTargetDir(outputDir);
                builder.setResolver(appState.getArtifactResolver());
                builder.setEffectiveModel(appState.getEffectiveModel());
                builder.setClassLoader((ClassLoader)runnerClassLoader);
                builder.setConfigCustomizer(this.configCustomizer);
                builder.setBuildSystemProperties(this.buildSystemProperties);
                builder.addFinal(BytecodeTransformerBuildItem.class).addFinal(ApplicationArchivesBuildItem.class).addFinal(MainClassBuildItem.class).addFinal(ArtifactResultBuildItem.class);
                result = builder.build().run();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            AugmentOutcome augmentOutcome = new AugmentOutcome(result.consumeMulti(ArtifactResultBuildItem.class), (JarBuildItem)result.consumeOptional(JarBuildItem.class), (NativeImageBuildItem)result.consumeOptional(NativeImageBuildItem.class));
            return augmentOutcome;
        }
        catch (Exception e) {
            throw new AppCreatorException("Failed to augment application classes", e);
        }
        finally {
            if (runnerClassLoader != null) {
                try {
                    runnerClassLoader.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Failed to close runner classloader", (Throwable)e);
                }
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public Path getAppClassesDir() {
        return this.appClassesDir;
    }

    public Path getConfigDir() {
        return this.configDir;
    }

    public Properties getBuildSystemProperties() {
        return this.buildSystemProperties;
    }

    public static class Builder {
        private Path outputDir;
        private Path appClassesDir;
        private Path configDir;
        private Properties buildSystemProperties;
        private Consumer<ConfigBuilder> configCustomizer;

        public Builder setOutputDir(Path outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        public Builder setAppClassesDir(Path appClassesDir) {
            this.appClassesDir = appClassesDir;
            return this;
        }

        public Builder setConfigDir(Path configDir) {
            this.configDir = configDir;
            return this;
        }

        public Builder setBuildSystemProperties(Properties buildSystemProperties) {
            this.buildSystemProperties = buildSystemProperties;
            return this;
        }

        public Builder setConfigCustomizer(Consumer<ConfigBuilder> configCustomizer) {
            this.configCustomizer = configCustomizer;
            return this;
        }

        public AugmentTask build() {
            return new AugmentTask(this);
        }
    }

    public static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path fromPath;
        private final Path toPath;
        private final CopyOption copyOption;

        public CopyDirVisitor(Path fromPath, Path toPath, CopyOption copyOption) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.copyOption = copyOption;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }
}

