/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.CommandLineParser;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;

public abstract class AbstractBuildOption<T, V extends CommandLineOptionConfiguration>
implements BuildOption<T> {
    protected final String gradleProperty;
    protected final List<V> commandLineOptionConfigurations;
    protected final String deprecatedGradleProperty;

    public AbstractBuildOption(String gradleProperty) {
        this(gradleProperty, (String)null, Collections.emptyList());
    }

    public AbstractBuildOption(String gradleProperty, String deprecatedGradleProperty, V ... commandLineOptionConfiguration) {
        this(gradleProperty, deprecatedGradleProperty, commandLineOptionConfiguration != null ? Arrays.asList(commandLineOptionConfiguration) : Collections.emptyList());
    }

    public AbstractBuildOption(String gradleProperty, V ... commandLineOptionConfiguration) {
        this(gradleProperty, (String)null, commandLineOptionConfiguration != null ? Arrays.asList(commandLineOptionConfiguration) : Collections.emptyList());
    }

    private AbstractBuildOption(String gradleProperty, String deprecatedGradleProperty, List<V> commandLineOptionConfigurations) {
        this.gradleProperty = gradleProperty;
        this.deprecatedGradleProperty = deprecatedGradleProperty;
        this.commandLineOptionConfigurations = commandLineOptionConfigurations;
    }

    @Override
    public String getGradleProperty() {
        return this.gradleProperty;
    }

    @Override
    public String getDeprecatedGradleProperty() {
        return this.deprecatedGradleProperty;
    }

    protected boolean isTrue(String value) {
        return value != null && value.trim().equalsIgnoreCase("true");
    }

    protected CommandLineOption configureCommandLineOption(CommandLineParser parser, String[] options, String description, boolean deprecated, boolean incubating) {
        CommandLineOption option = parser.option(options).hasDescription(description);
        if (deprecated) {
            option.deprecated();
        }
        if (incubating) {
            option.incubating();
        }
        return option;
    }

    protected OptionValue<String> getFromProperties(Map<String, String> properties) {
        String value = properties.get(this.gradleProperty);
        if (value != null) {
            return new OptionValue<String>(value, Origin.forGradleProperty(this.gradleProperty));
        }
        if (this.deprecatedGradleProperty != null && (value = properties.get(this.deprecatedGradleProperty)) != null) {
            return new OptionValue<String>(value, Origin.forGradleProperty(this.deprecatedGradleProperty));
        }
        return new OptionValue<Object>(null, null);
    }

    protected static class OptionValue<T> {
        private final T value;
        private final Origin origin;

        public OptionValue(T value, Origin origin) {
            this.value = value;
            this.origin = origin;
        }

        public T getValue() {
            return this.value;
        }

        public Origin getOrigin() {
            return this.origin;
        }
    }
}

