/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics.util;

import io.quarkus.analytics.dto.config.LocalConfig;
import io.quarkus.analytics.dto.config.RemoteConfig;
import io.quarkus.analytics.dto.segment.Track;
import io.quarkus.analytics.util.JsonSerializer;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public class FileUtils {
    public static void createFileAndParent(Path path) throws IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    public static void append(String content, Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.append(content);
        }
    }

    public static <T> void write(T content, Path path) throws IOException {
        String json = FileUtils.toJson(content);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(json);
        }
    }

    public static <T> void overwrite(T content, Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        FileUtils.createFileAndParent(path);
        String json = FileUtils.toJson(content);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(json);
        }
    }

    public static <T> Optional<T> read(Class<T> clazz, Path path, MessageWriter log) throws IOException {
        try {
            String json = Files.readString(path);
            Object result = FileUtils.fromJson(clazz, json);
            return Optional.of(result);
        }
        catch (Exception e) {
            log.warn("[Quarkus build analytics] Could not read {}", new Object[]{path.toString(), e});
            return Optional.empty();
        }
        catch (Throwable t) {
            log.error("[Quarkus build analytics] Unexpected error reading class " + t.getClass().getName() + " from path: " + path.toString() + ". Got message: " + t.getMessage() + ". Attempting to continue...");
            return Optional.empty();
        }
    }

    private static <T> String toJson(T content) {
        if (content instanceof RemoteConfig) {
            RemoteConfig remoteConfig = (RemoteConfig)content;
            return JsonSerializer.toJson(remoteConfig);
        }
        if (content instanceof LocalConfig) {
            LocalConfig localConfig = (LocalConfig)content;
            return JsonSerializer.toJson(localConfig);
        }
        if (content instanceof Track) {
            Track track = (Track)content;
            return JsonSerializer.toJson(track);
        }
        throw new IllegalArgumentException("Unsupported type for JSON serialization: " + content.getClass().getName());
    }

    private static Object fromJson(Class<?> clazz, String json) {
        if (clazz == RemoteConfig.class) {
            return JsonSerializer.parseRemoteConfig(json);
        }
        if (clazz == LocalConfig.class) {
            return JsonSerializer.parseLocalConfig(json);
        }
        if (clazz == Track.class) {
            return JsonSerializer.parseTrack(json);
        }
        throw new IllegalArgumentException("Unsupported type for JSON deserialization: " + clazz.getName());
    }
}

