/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.InstanceFieldCreator;
import io.quarkus.gizmo2.creator.ModifierLocation;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.impl.FieldCreatorImpl;
import io.quarkus.gizmo2.impl.TypeCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.classfile.ClassFileElement;
import io.smallrye.classfile.FieldBuilder;
import io.smallrye.classfile.Signature;
import io.smallrye.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.SignatureAttribute;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.util.function.Consumer;

public final class InstanceFieldCreatorImpl
extends FieldCreatorImpl
implements InstanceFieldCreator {
    private Const initial;
    private Consumer<BlockCreator> initializer;

    public InstanceFieldCreatorImpl(TypeCreatorImpl tc, ClassDesc owner, String name) {
        super(owner, name, tc);
    }

    @Override
    public ModifierLocation modifierLocation() {
        return ModifierLocation.CLASS_INSTANCE_FIELD;
    }

    @Override
    public void setInitial(Const initial) {
        Assert.checkNotNullParam((String)"initial", (Object)initial);
        this.checkOneInit();
        this.setType(initial.type());
        this.initial = initial;
    }

    @Override
    public void setInitializer(Consumer<BlockCreator> init) {
        Assert.checkNotNullParam((String)"init", init);
        this.checkOneInit();
        this.initializer = b0 -> {
            FieldDesc desc = this.desc();
            b0.set((Assignable)this.tc.this_().field(desc), b0.blockExpr(desc.type(), init));
        };
    }

    private void checkOneInit() {
        if (this.initial != null || this.initializer != null) {
            throw new IllegalStateException("An instance field may have only one initializer");
        }
    }

    void accept(Consumer<InstanceFieldCreator> builder) {
        builder.accept(this);
        if (this.initial != null) {
            this.tc.instancePreinitializer(b0 -> b0.set((Assignable)this.tc.this_().field(this.desc()), this.initial));
        } else if (this.initializer != null) {
            this.tc.instanceInitializer(this.initializer);
        }
        this.tc.zb.withField(this.name(), this.desc().type(), fb -> {
            fb.withFlags(this.modifiers);
            if (this.genericType != null && !this.genericType.isRaw()) {
                fb.with((ClassFileElement)SignatureAttribute.of((Signature)Util.signatureOf(this.genericType())));
            }
            this.addVisible((Consumer<? super RuntimeVisibleAnnotationsAttribute>)fb);
            this.addInvisible((Consumer<? super RuntimeInvisibleAnnotationsAttribute>)fb);
            this.addTypeAnnotations((FieldBuilder)fb);
        });
    }
}

