/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.creator.ModifierLocation;
import io.quarkus.gizmo2.creator.ParamCreator;
import io.quarkus.gizmo2.impl.GizmoImpl;
import io.quarkus.gizmo2.impl.ModifiableCreatorImpl;
import io.quarkus.gizmo2.impl.ParamVarImpl;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.ElementType;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.List;
import java.util.function.Consumer;

public final class ParamCreatorImpl
extends ModifiableCreatorImpl
implements ParamCreator {
    boolean typeEstablished;
    ClassDesc type;
    GenericType genericType;

    public ParamCreatorImpl(GizmoImpl gizmo) {
        super(gizmo);
    }

    public ParamCreatorImpl(GizmoImpl gizmo, GenericType type) {
        super(gizmo);
        this.genericType = type;
        this.typeEstablished = true;
    }

    @Override
    public ModifierLocation modifierLocation() {
        return ModifierLocation.PARAMETER;
    }

    ParamVarImpl apply(Consumer<ParamCreator> builder, String name, int index, int slot) {
        builder.accept(this);
        if (this.type == null && this.genericType == null) {
            throw new IllegalStateException("Parameter type was not set");
        }
        this.typeEstablished = true;
        return new ParamVarImpl(this.type, this.genericType, name, index, slot, this.modifiers, List.copyOf(this.invisible.values()), List.copyOf(this.visible.values()));
    }

    @Override
    public void setType(GenericType genericType) {
        Assert.checkNotNullParam((String)"type", (Object)genericType);
        if (this.typeEstablished && !genericType.equals(this.genericType)) {
            throw new IllegalArgumentException("Given type " + String.valueOf(genericType) + " differs from established type " + String.valueOf(this.genericType));
        }
        this.setType(genericType.desc());
        this.genericType = genericType;
    }

    @Override
    public void setType(ClassDesc type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        if (type.equals(ConstantDescs.CD_void)) {
            throw new IllegalArgumentException("Bad type for parameter: " + String.valueOf(type));
        }
        if (this.typeEstablished && !type.equals(this.type)) {
            throw new IllegalArgumentException("Given type " + String.valueOf(type) + " differs from established type " + String.valueOf(this.type));
        }
        this.type = type;
    }

    @Override
    public ClassDesc type() {
        return this.type;
    }

    @Override
    public GenericType genericType() {
        return this.genericType;
    }

    @Override
    public boolean hasGenericType() {
        return this.genericType != null;
    }

    @Override
    public ElementType annotationTargetType() {
        return ElementType.PARAMETER;
    }
}

