/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.ExtensionInvoker;
import io.quarkus.arc.processor.bcextensions.ExtensionMethod;
import io.quarkus.arc.processor.bcextensions.ExtensionMethodParameter;
import io.quarkus.arc.processor.bcextensions.ExtensionPhase;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseBase;
import io.quarkus.arc.processor.bcextensions.SharedErrors;
import io.quarkus.arc.processor.bcextensions.SyntheticBeanBuilderImpl;
import io.quarkus.arc.processor.bcextensions.SyntheticComponentsImpl;
import io.quarkus.arc.processor.bcextensions.SyntheticObserverBuilderImpl;
import io.quarkus.arc.processor.bcextensions.TypesImpl;
import java.util.List;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class ExtensionPhaseSynthesis
extends ExtensionPhaseBase {
    private final AllAnnotationOverlays annotationOverlays;
    private final List<SyntheticBeanBuilderImpl<?>> syntheticBeans;
    private final List<SyntheticObserverBuilderImpl<?>> syntheticObservers;

    ExtensionPhaseSynthesis(ExtensionInvoker invoker, IndexView beanArchiveIndex, SharedErrors errors, AllAnnotationOverlays annotationOverlays, List<SyntheticBeanBuilderImpl<?>> syntheticBeans, List<SyntheticObserverBuilderImpl<?>> syntheticObservers) {
        super(ExtensionPhase.SYNTHESIS, invoker, beanArchiveIndex, errors);
        this.annotationOverlays = annotationOverlays;
        this.syntheticBeans = syntheticBeans;
        this.syntheticObservers = syntheticObservers;
    }

    @Override
    Object argumentForExtensionMethod(ExtensionMethodParameter type, ExtensionMethod method) {
        switch (type) {
            case SYNTHETIC_COMPONENTS: {
                DotName extensionClass = method.extensionClass.name();
                return new SyntheticComponentsImpl(this.syntheticBeans, this.syntheticObservers, extensionClass);
            }
            case TYPES: {
                return new TypesImpl(this.index, this.annotationOverlays);
            }
        }
        return super.argumentForExtensionMethod(type, method);
    }
}

