/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AbstractAnnotationsTransformation;
import io.quarkus.arc.processor.AnnotationsTransformationContext;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.ObserverTransformer;
import io.quarkus.gizmo.MethodCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.DefinitionException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ObserverInfo
implements InjectionTargetInfo {
    private static final Logger LOGGER = Logger.getLogger((String)ObserverInfo.class.getName());
    private final BeanDeployment beanDeployment;
    private final DotName beanClass;
    private final BeanInfo declaringBean;
    private final MethodInfo observerMethod;
    private final Injection injection;
    private final MethodParameterInfo eventParameter;
    private final int eventMetadataParameterPosition;
    private final int priority;
    private final boolean isAsync;
    private final Reception reception;
    private final TransactionPhase transactionPhase;
    private final Type observedType;
    private final Set<AnnotationInstance> qualifiers;
    private final Consumer<MethodCreator> notify;

    static ObserverInfo create(BeanInfo declaringBean, MethodInfo observerMethod, Injection injection, boolean isAsync, List<ObserverTransformer> transformers, BuildExtension.BuildContext buildContext, boolean jtaCapabilities) {
        MethodParameterInfo eventParameter = ObserverInfo.initEventParam(observerMethod, declaringBean.getDeployment());
        AnnotationInstance priorityAnnotation = observerMethod.annotation(DotNames.PRIORITY);
        Integer priority = priorityAnnotation != null && priorityAnnotation.target().equals(eventParameter) ? Integer.valueOf(priorityAnnotation.value().asInt()) : Integer.valueOf(2500);
        return ObserverInfo.create(declaringBean.getDeployment(), declaringBean.getTarget().get().asClass().name(), declaringBean, observerMethod, injection, eventParameter, (Type)observerMethod.parameters().get(eventParameter.position()), ObserverInfo.initQualifiers(declaringBean.getDeployment(), observerMethod, eventParameter), ObserverInfo.initReception(isAsync, declaringBean.getDeployment(), observerMethod), ObserverInfo.initTransactionPhase(isAsync, declaringBean.getDeployment(), observerMethod), isAsync, priority, transformers, buildContext, jtaCapabilities, null);
    }

    static ObserverInfo create(BeanDeployment beanDeployment, DotName beanClass, BeanInfo declaringBean, MethodInfo observerMethod, Injection injection, MethodParameterInfo eventParameter, Type observedType, Set<AnnotationInstance> qualifiers, Reception reception, TransactionPhase transactionPhase, boolean isAsync, int priority, List<ObserverTransformer> transformers, BuildExtension.BuildContext buildContext, boolean jtaCapabilities, Consumer<MethodCreator> notify) {
        if (!transformers.isEmpty()) {
            ObserverTransformationContext context = new ObserverTransformationContext(buildContext, (AnnotationTarget)observerMethod, observedType, qualifiers, reception, transactionPhase, priority, isAsync);
            for (ObserverTransformer transformer : transformers) {
                if (!transformer.appliesTo(observedType, qualifiers)) continue;
                transformer.transform(context);
                if (!context.vetoed) continue;
                String info = observerMethod != null ? String.format("method %s.%s()", observerMethod.declaringClass().name(), observerMethod.name()) : beanClass.toString();
                LOGGER.debugf("Observer %s vetoed by %s", (Object)info, (Object)transformer.getClass().getName());
                break;
            }
            if (context.vetoed) {
                return null;
            }
            qualifiers = context.getQualifiers();
            reception = context.getReception();
            transactionPhase = context.getTransactionPhase();
            priority = context.getPriority();
            isAsync = context.isAsync();
        }
        if (!transactionPhase.equals((Object)TransactionPhase.IN_PROGRESS) && !jtaCapabilities) {
            String info = observerMethod != null ? String.format("method %s.%s()", observerMethod.declaringClass().name(), observerMethod.name()) : beanClass.toString();
            LOGGER.warnf("The observer %s#%s makes use of '%s' transactional observers but no JTA capabilities were detected.", (Object)info, (Object)transactionPhase);
        }
        return new ObserverInfo(beanDeployment, beanClass, declaringBean, observerMethod, injection, eventParameter, isAsync, priority, reception, transactionPhase, observedType, qualifiers, notify);
    }

    ObserverInfo(BeanDeployment beanDeployment, DotName beanClass, BeanInfo declaringBean, MethodInfo observerMethod, Injection injection, MethodParameterInfo eventParameter, boolean isAsync, int priority, Reception reception, TransactionPhase transactionPhase, Type observedType, Set<AnnotationInstance> qualifiers, Consumer<MethodCreator> notify) {
        this.beanDeployment = beanDeployment;
        this.beanClass = beanClass;
        this.declaringBean = declaringBean;
        this.observerMethod = observerMethod;
        this.injection = injection;
        this.eventParameter = eventParameter;
        this.eventMetadataParameterPosition = this.initEventMetadataParam(observerMethod);
        this.isAsync = isAsync;
        this.priority = priority;
        this.reception = reception;
        this.transactionPhase = transactionPhase;
        this.observedType = observedType;
        this.qualifiers = qualifiers;
        this.notify = notify;
    }

    @Override
    public InjectionTargetInfo.TargetKind kind() {
        return InjectionTargetInfo.TargetKind.OBSERVER;
    }

    @Override
    public ObserverInfo asObserver() {
        return this;
    }

    BeanDeployment getBeanDeployment() {
        return this.beanDeployment;
    }

    public DotName getBeanClass() {
        return this.beanClass;
    }

    public BeanInfo getDeclaringBean() {
        return this.declaringBean;
    }

    public boolean isSynthetic() {
        return this.getDeclaringBean() == null;
    }

    public MethodInfo getObserverMethod() {
        return this.observerMethod;
    }

    public MethodParameterInfo getEventParameter() {
        return this.eventParameter;
    }

    public Reception getReception() {
        return this.reception;
    }

    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    int getEventMetadataParameterPosition() {
        return this.eventMetadataParameterPosition;
    }

    Injection getInjection() {
        return this.injection;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public Type getObservedType() {
        return this.observedType;
    }

    public Set<AnnotationInstance> getQualifiers() {
        return this.qualifiers;
    }

    Consumer<MethodCreator> getNotify() {
        return this.notify;
    }

    void init(List<Throwable> errors) {
        if (this.injection != null) {
            for (InjectionPointInfo injectionPoint : this.injection.injectionPoints) {
                Beans.resolveInjectionPoint(this.declaringBean.getDeployment(), this, injectionPoint, errors);
            }
        }
    }

    static Reception initReception(boolean isAsync, BeanDeployment beanDeployment, MethodInfo observerMethod) {
        AnnotationInstance observesAnnotation = isAsync ? beanDeployment.getAnnotation((AnnotationTarget)observerMethod, DotNames.OBSERVES_ASYNC) : beanDeployment.getAnnotation((AnnotationTarget)observerMethod, DotNames.OBSERVES);
        AnnotationValue receptionValue = observesAnnotation.value("notifyObserver");
        if (receptionValue == null) {
            return Reception.ALWAYS;
        }
        return Reception.valueOf((String)receptionValue.asEnum());
    }

    static TransactionPhase initTransactionPhase(boolean isAsync, BeanDeployment beanDeployment, MethodInfo observerMethod) {
        AnnotationInstance observesAnnotation = isAsync ? beanDeployment.getAnnotation((AnnotationTarget)observerMethod, DotNames.OBSERVES_ASYNC) : beanDeployment.getAnnotation((AnnotationTarget)observerMethod, DotNames.OBSERVES);
        AnnotationValue duringValue = observesAnnotation.value("during");
        if (duringValue == null) {
            return TransactionPhase.IN_PROGRESS;
        }
        return TransactionPhase.valueOf((String)duringValue.asEnum());
    }

    static Set<AnnotationInstance> initQualifiers(BeanDeployment beanDeployment, MethodInfo observerMethod, MethodParameterInfo eventParameter) {
        HashSet<AnnotationInstance> qualifiers = new HashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)observerMethod)) {
            if (!annotation.target().equals(eventParameter)) continue;
            beanDeployment.extractQualifiers(annotation).forEach(qualifiers::add);
        }
        return qualifiers;
    }

    int getPriority() {
        return this.priority;
    }

    static MethodParameterInfo initEventParam(MethodInfo observerMethod, BeanDeployment beanDeployment) {
        ArrayList<MethodParameterInfo> eventParams = new ArrayList<MethodParameterInfo>();
        for (AnnotationInstance annotation : beanDeployment.getAnnotations((AnnotationTarget)observerMethod)) {
            if (AnnotationTarget.Kind.METHOD_PARAMETER != annotation.target().kind() || !annotation.name().equals((Object)DotNames.OBSERVES) && !annotation.name().equals((Object)DotNames.OBSERVES_ASYNC)) continue;
            eventParams.add(annotation.target().asMethodParameter());
        }
        if (eventParams.isEmpty()) {
            throw new DefinitionException("No event parameters found for " + observerMethod);
        }
        if (eventParams.size() > 1) {
            throw new DefinitionException("Multiple event parameters found for " + observerMethod);
        }
        return (MethodParameterInfo)eventParams.get(0);
    }

    int initEventMetadataParam(MethodInfo observerMethod) {
        if (observerMethod != null) {
            ListIterator iterator = observerMethod.parameters().listIterator();
            while (iterator.hasNext()) {
                if (!((Type)iterator.next()).name().equals((Object)DotNames.EVENT_METADATA)) continue;
                return iterator.previousIndex();
            }
        }
        return -1;
    }

    private static class ObserverTransformationImpl
    extends AbstractAnnotationsTransformation<ObserverTransformer.ObserverTransformation, Set<AnnotationInstance>>
    implements ObserverTransformer.ObserverTransformation {
        private final ObserverTransformationContext context;
        private Integer priority;
        private Reception reception;
        private TransactionPhase transactionPhase;
        private Boolean async;

        public ObserverTransformationImpl(Set<AnnotationInstance> qualifiers, MethodInfo observerMethod, ObserverTransformationContext context) {
            super(qualifiers, (AnnotationTarget)observerMethod, null);
            this.context = context;
        }

        @Override
        protected ObserverTransformer.ObserverTransformation self() {
            return this;
        }

        @Override
        public ObserverTransformer.ObserverTransformation priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public ObserverTransformer.ObserverTransformation reception(Reception reception) {
            this.reception = reception;
            return this;
        }

        @Override
        public ObserverTransformer.ObserverTransformation transactionPhase(TransactionPhase transactionPhase) {
            this.transactionPhase = transactionPhase;
            return this;
        }

        @Override
        public ObserverTransformer.ObserverTransformation async(boolean value) {
            this.async = value;
            return this;
        }

        @Override
        public void done() {
            this.context.setAnnotations(this.modifiedAnnotations);
            if (this.reception != null) {
                this.context.reception = this.reception;
            }
            if (this.priority != null) {
                this.context.priority = this.priority;
            }
            if (this.transactionPhase != null) {
                this.context.transactionPhase = this.transactionPhase;
            }
            if (this.async != null) {
                this.context.async = this.async;
            }
        }
    }

    private static class ObserverTransformationContext
    extends AnnotationsTransformationContext<Set<AnnotationInstance>>
    implements ObserverTransformer.TransformationContext {
        private final Type observedType;
        private Reception reception;
        private TransactionPhase transactionPhase;
        private Integer priority;
        private boolean vetoed;
        private boolean async;

        public ObserverTransformationContext(BuildExtension.BuildContext buildContext, AnnotationTarget target, Type observedType, Set<AnnotationInstance> qualifiers, Reception reception, TransactionPhase transactionPhase, Integer priority, boolean async) {
            super(buildContext, target, qualifiers);
            this.observedType = observedType;
            this.reception = reception;
            this.transactionPhase = transactionPhase;
            this.priority = priority;
            this.async = async;
        }

        @Override
        public MethodInfo getMethod() {
            return this.target != null ? this.target.asMethod() : null;
        }

        @Override
        public Type getObservedType() {
            return this.observedType;
        }

        @Override
        public Set<AnnotationInstance> getQualifiers() {
            return (Set)this.getAnnotations();
        }

        @Override
        public Reception getReception() {
            return this.reception;
        }

        @Override
        public TransactionPhase getTransactionPhase() {
            return this.transactionPhase;
        }

        public Integer getPriority() {
            return this.priority;
        }

        @Override
        public boolean isAsync() {
            return this.async;
        }

        @Override
        public void veto() {
            this.vetoed = true;
        }

        @Override
        public ObserverTransformer.ObserverTransformation transform() {
            return new ObserverTransformationImpl(new HashSet<AnnotationInstance>((Collection<AnnotationInstance>)this.getAnnotations()), this.getMethod(), this);
        }
    }
}

