/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationsTransformation;
import io.quarkus.arc.processor.DotNames;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

abstract class AbstractAnnotationsTransformation<T extends AnnotationsTransformation<T>, C extends Collection<AnnotationInstance>>
implements AnnotationsTransformation<T> {
    private final AnnotationTarget target;
    private final Consumer<C> resultConsumer;
    protected final C modifiedAnnotations;

    public AbstractAnnotationsTransformation(C annotations, AnnotationTarget target, Consumer<C> resultConsumer) {
        this.target = target;
        this.resultConsumer = resultConsumer;
        this.modifiedAnnotations = annotations;
    }

    @Override
    public T add(AnnotationInstance annotation) {
        this.modifiedAnnotations.add((AnnotationInstance)annotation);
        return this.self();
    }

    @Override
    public T addAll(Collection<AnnotationInstance> annotations) {
        this.modifiedAnnotations.addAll(annotations);
        return this.self();
    }

    @Override
    public T addAll(AnnotationInstance ... annotations) {
        Collections.addAll(this.modifiedAnnotations, annotations);
        return this.self();
    }

    @Override
    public T add(Class<? extends Annotation> annotationType, AnnotationValue ... values) {
        this.add(DotNames.create(annotationType.getName()), values);
        return this.self();
    }

    @Override
    public T add(DotName name, AnnotationValue ... values) {
        this.add(AnnotationInstance.create((DotName)name, (AnnotationTarget)this.target, (AnnotationValue[])values));
        return this.self();
    }

    @Override
    public T remove(Predicate<AnnotationInstance> predicate) {
        this.modifiedAnnotations.removeIf(predicate);
        return this.self();
    }

    @Override
    public T removeAll() {
        this.modifiedAnnotations.clear();
        return this.self();
    }

    @Override
    public void done() {
        this.resultConsumer.accept(this.modifiedAnnotations);
    }

    protected abstract T self();
}

