/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.compiler.CachingProtoLoader;
import io.protostuff.compiler.CompilerUtil;
import io.protostuff.compiler.Formatter;
import io.protostuff.compiler.ProtoCompiler;
import io.protostuff.compiler.ProtoModule;
import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;

public abstract class STCodeGenerator
implements ProtoCompiler {
    public static final String TEMPLATE_BASE = "io/protostuff/compiler";
    public static final Pattern FORMAT_DELIM = Pattern.compile("&&");
    static final ConcurrentHashMap<Class<?>, AttributeRenderer> DEFAULT_RENDERERS = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, Formatter> DEFAULT_FORMATTERS = new ConcurrentHashMap();
    public static int errorCount = 0;
    public static final StringTemplateErrorListener ERROR_LISTENER = new StringTemplateErrorListener(){

        public void error(String msg, Throwable e) {
            ++errorCount;
            System.err.println("error: " + msg);
        }

        public void warning(String msg) {
            System.err.println("warning: " + msg);
        }
    };
    public static final CommonGroupLoader GROUP_LOADER = new CommonGroupLoader("io/protostuff/compiler", ERROR_LISTENER);
    public static final AttributeRenderer STRING_ATTRIBUTE_RENDERER = new AttributeRenderer(){

        public String toString(Object o) {
            return (String)o;
        }

        public String toString(Object o, String formatName) {
            String str = (String)o;
            if (formatName == null) {
                return str;
            }
            String[] formats = FORMAT_DELIM.split(formatName);
            return formats.length == 0 ? STCodeGenerator.format(str, formatName) : STCodeGenerator.chainedFormat(str, formats);
        }
    };
    private static StringTemplateGroupLoader __loader;
    protected final String id;

    public static String chainedFormat(String str, String[] formats) {
        String formatted = str;
        for (String f : formats) {
            formatted = STCodeGenerator.format(formatted, f);
        }
        return formatted;
    }

    public static String format(String str, String formatName) {
        Formatter formatter = DEFAULT_FORMATTERS.get(formatName);
        if (formatter != null) {
            return formatter.format(str);
        }
        int eq = formatName.indexOf("==");
        if (eq > 0) {
            String toReplace = formatName.substring(0, eq);
            String replacement = formatName.substring(eq + 2);
            if (toReplace.length() == 1 && replacement.length() == 1) {
                return str.replace(toReplace.charAt(0), replacement.charAt(0));
            }
            return str.replaceAll(toReplace, replacement);
        }
        return str + formatName;
    }

    public static boolean setAttributeRenderer(Class<?> typeClass, AttributeRenderer ar) {
        return null == DEFAULT_RENDERERS.put(typeClass, ar);
    }

    public static boolean setFormatter(String name, Formatter f) {
        return null == DEFAULT_FORMATTERS.put(name, f);
    }

    public static StringTemplateGroup getSTG(String groupName) {
        return __loader.loadGroup(groupName);
    }

    public static StringTemplate getST(String groupName, String name) {
        return STCodeGenerator.getSTG(groupName).getInstanceOf(name);
    }

    public static void setGroupLoader(StringTemplateGroupLoader loader) {
        if (loader != null) {
            __loader = loader;
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)loader);
        }
    }

    public STCodeGenerator(String id) {
        this.id = id;
    }

    @Override
    public String getOutputId() {
        return this.id;
    }

    @Override
    public void compile(ProtoModule module) throws IOException {
        String ci = module.getOption("compile_imports");
        boolean compileImports = ci != null && !"false".equalsIgnoreCase(ci);
        boolean recursive = "recursive".equalsIgnoreCase(ci);
        File source = module.getSource();
        if (source.isDirectory()) {
            for (File f : CompilerUtil.getProtoFiles(source)) {
                this.compile(module, STCodeGenerator.parseProto(f, module), compileImports, recursive);
            }
        } else {
            this.compile(module, STCodeGenerator.parseProto(source, module), compileImports, recursive);
        }
    }

    protected static Proto parseProto(File file, ProtoModule module) {
        CachingProtoLoader loader = module.getCachingProtoLoader();
        if (loader == null) {
            return ProtoUtil.parseProto((File)file);
        }
        try {
            return loader.loadFrom(file, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compile(ProtoModule module, Proto proto, boolean compileImports, boolean recursive) throws IOException {
        ArrayList<Proto> overridden = new ArrayList<Proto>();
        try {
            this.collect(module, proto, overridden, recursive);
            if (!recursive) {
                this.compile(module, proto);
                if (compileImports) {
                    for (Proto p : proto.getImportedProtos()) {
                        this.compile(module, p);
                    }
                }
            }
        }
        finally {
            for (Proto p : overridden) {
                STCodeGenerator.postCompile(module, p);
            }
        }
    }

    protected void collect(ProtoModule module, Proto proto, List<Proto> overridden, boolean compile) throws IOException {
        for (Proto p : proto.getImportedProtos()) {
            this.collect(module, p, overridden, compile);
        }
        if (STCodeGenerator.override(module, proto)) {
            overridden.add(proto);
        }
        if (compile) {
            this.compile(module, proto);
        }
    }

    protected static boolean override(ProtoModule module, Proto proto) {
        String pkg = proto.getPackageName();
        String jpkg = proto.getJavaPackageName();
        String opkg = module.getOption(pkg);
        String ojpkg = module.getOption(jpkg);
        boolean override = false;
        if (opkg != null && opkg.length() != 0) {
            proto.getMutablePackageName().override((Object)opkg);
            override = true;
        }
        if (ojpkg != null && ojpkg.length() != 0) {
            proto.getMutableJavaPackageName().override((Object)ojpkg);
            override = true;
        }
        return override;
    }

    protected static void postCompile(ProtoModule module, Proto proto) {
        proto.getMutableJavaPackageName().reset();
        proto.getMutablePackageName().reset();
    }

    protected abstract void compile(ProtoModule var1, Proto var2) throws IOException;

    static {
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)GROUP_LOADER);
        STCodeGenerator.setAttributeRenderer(String.class, STRING_ATTRIBUTE_RENDERER);
        GROUP_LOADER.loadGroup("base").setAttributeRenderers(DEFAULT_RENDERERS);
        Formatter.BUILTIN.addAllTo(DEFAULT_FORMATTERS);
        __loader = GROUP_LOADER;
    }
}

