/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.compiler.CompilerUtil;
import io.protostuff.compiler.ProtoModule;
import io.protostuff.compiler.STCodeGenerator;
import io.protostuff.parser.Annotation;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.stringtemplate.NoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;

public class ProtoToProtoCompiler
extends STCodeGenerator {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public ProtoToProtoCompiler() {
        super("proto_extender");
    }

    @Override
    public void compile(ProtoModule module, Proto proto) throws IOException {
        StringTemplateGroup group = ProtoToProtoCompiler.getSTG("proto_to_proto");
        String src = module.getSource().getAbsolutePath();
        String path = proto.getFile().getAbsolutePath().replace(src, "").replace(proto.getFile().getName(), "");
        Writer writer = CompilerUtil.newWriter(module, path, proto.getFile().getName());
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(proto.getFile()));
        String line = reader.readLine();
        while (line != null) {
            builder.append(line);
            builder.append(LINE_SEPARATOR);
            line = reader.readLine();
        }
        reader.close();
        String data = builder.toString();
        for (Message message : proto.getMessages()) {
            Object extOpt;
            String result;
            Message base;
            Annotation annotation = message.getAnnotation("Extend");
            if (annotation != null) {
                Object byMessageRef = annotation.getValue("by");
                if (byMessageRef == null) {
                    throw new IllegalArgumentException("By parameter of attribute @Extend is not specified");
                }
                if (!(byMessageRef instanceof Message)) {
                    throw new IllegalArgumentException("By parameter have a non Message reference in your @Extend annotation");
                }
                base = (Message)byMessageRef;
                result = ProtoToProtoCompiler.extendBy(group, message, base);
                if (result != null && result.length() > 0) {
                    data = ProtoToProtoCompiler.injectAfterAnnotation(message, base, data, result);
                }
            }
            if ((extOpt = message.getExtraOption("extends")) == null) continue;
            if (!(extOpt instanceof Message)) {
                throw new IllegalArgumentException("Option extends specified not a message reference");
            }
            base = (Message)extOpt;
            result = ProtoToProtoCompiler.extendBy(group, message, base);
            if (result == null || result.length() <= 0) continue;
            data = ProtoToProtoCompiler.injectAfterOption(message, base, data, result);
        }
        writer.write(data);
        writer.close();
    }

    public static String extendBy(StringTemplateGroup group, Message extend, Message by) throws IOException {
        StringWriter stringer = new StringWriter(16);
        NoIndentWriter out = new NoIndentWriter((Writer)stringer);
        StringTemplate messageBlock = group.getInstanceOf("extend_by");
        messageBlock.setAttribute("message", (Object)extend);
        messageBlock.setAttribute("by", (Object)by);
        messageBlock.write((StringTemplateWriter)out);
        return stringer.toString();
    }

    public static String injectAfterAnnotation(Message extend, Message by, String extendProto, String byContent) {
        Pattern messageRegexp = Pattern.compile("[\\n\\r]?([ \\t]*)(message\\s+" + extend.getName() + "\\s+\\{)", 8);
        int messageIndex = -1;
        int openBracketIndex = -1;
        Matcher matcher = messageRegexp.matcher(extendProto);
        if (matcher.find()) {
            int is = matcher.start(1);
            int ie = matcher.end(1);
            String indentation = ProtoToProtoCompiler.generateIndentation(extendProto.substring(is, ie), 4);
            messageIndex = matcher.start(2);
            openBracketIndex = matcher.end(2);
            extendProto = extendProto.substring(0, openBracketIndex) + LINE_SEPARATOR + indentation + "// " + ProtoToProtoCompiler.generateTimestamp(extend, by) + LINE_SEPARATOR + ProtoToProtoCompiler.insertIndentation(byContent, indentation) + LINE_SEPARATOR + extendProto.substring(openBracketIndex);
        }
        Pattern annotationRegexp = Pattern.compile("[\\n\\r]?([ \\t]*@Extend\\s*\\([^)]+" + by.getName() + "[^)]*\\))");
        String annotationSpace = extendProto.substring(0, messageIndex);
        matcher = annotationRegexp.matcher(annotationSpace);
        int astart = -1;
        int aend = 0;
        while (matcher.find(aend)) {
            astart = matcher.start(1);
            aend = matcher.end(1);
        }
        if (astart > -1) {
            extendProto = extendProto.substring(0, astart) + "// " + extendProto.substring(astart);
        }
        return extendProto;
    }

    public static String injectAfterOption(Message extend, Message by, String extendProto, String byContent) {
        Pattern messageRegexp = Pattern.compile("([\\n\\r]?[ \\t]*message\\s+" + extend.getName() + "\\s+\\{[^{}]*[\\n\\r][ \\t]*)(option\\s+extends\\s+=\\s+" + by.getName() + "\\s*;)", 8);
        Matcher matcher = messageRegexp.matcher(extendProto);
        if (matcher.find()) {
            Pattern indentRegexp = Pattern.compile("[\\n\\r]([ \\t]+)option\\s+extends\\s+=\\s+" + by.getName() + "\\s*;", 8);
            Matcher indent = indentRegexp.matcher(extendProto.substring(matcher.start(), matcher.end()));
            String indentation = "";
            if (indent.find()) {
                int is = matcher.start() + indent.start(1);
                int ie = matcher.start() + indent.end(1);
                indentation = ProtoToProtoCompiler.generateIndentation(extendProto.substring(is, ie), 0);
            }
            StringBuffer sb = new StringBuffer();
            matcher.appendReplacement(sb, "$1// " + ProtoToProtoCompiler.generateTimestamp(extend, by) + LINE_SEPARATOR + indentation + "// $2" + LINE_SEPARATOR + ProtoToProtoCompiler.insertIndentation(byContent, indentation));
            matcher.appendTail(sb);
            return sb.toString();
        }
        return extendProto;
    }

    public static String insertIndentation(String content, String indent) {
        if (!content.startsWith(LINE_SEPARATOR)) {
            content = indent + content;
        }
        return content.replace(LINE_SEPARATOR, LINE_SEPARATOR + indent);
    }

    public static String generateIndentation(String indentation, int length) {
        if (indentation == null) {
            indentation = "";
        }
        StringBuilder builder = new StringBuilder(indentation);
        for (int i = 0; i < length; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    public static String generateTimestamp(Message extend, Message by) {
        return "Extended by " + by.getName() + " at " + new Date();
    }
}

