/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.HttpConversionUtil;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpToH2Operations;

final class Http2StreamBridgeHandler
extends ChannelDuplexHandler {
    final boolean readForwardHeaders;
    final ConnectionObserver listener;
    final ServerCookieEncoder cookieEncoder;
    final ServerCookieDecoder cookieDecoder;

    Http2StreamBridgeHandler(ConnectionObserver listener, boolean readForwardHeaders, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        this.readForwardHeaders = readForwardHeaders;
        this.listener = listener;
        this.cookieEncoder = encoder;
        this.cookieDecoder = decoder;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New http2 connection, requesting read"));
        }
        ctx.read();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            Object request = headersFrame.isEndStream() ? HttpConversionUtil.toFullHttpRequest((int)-1, (Http2Headers)headersFrame.headers(), (ByteBufAllocator)ctx.channel().alloc(), (boolean)false) : HttpConversionUtil.toHttpRequest((int)-1, (Http2Headers)headersFrame.headers(), (boolean)false);
            new HttpToH2Operations(Connection.from(ctx.channel()), this.listener, (HttpRequest)request, headersFrame.headers(), ConnectionInfo.from(ctx.channel().parent(), this.readForwardHeaders, request), this.cookieEncoder, this.cookieDecoder).bind();
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof Http2Headers) {
            msg = new DefaultHttp2HeadersFrame((Http2Headers)msg);
        }
        boolean endOfHttp2Stream = false;
        if (msg instanceof Http2DataFrame) {
            endOfHttp2Stream = ((Http2DataFrame)msg).isEndStream();
        }
        if (!endOfHttp2Stream && msg instanceof ByteBuf && ctx.channel() instanceof Http2StreamChannel) {
            msg = new DefaultHttp2DataFrame((ByteBuf)msg);
        }
        ctx.write(msg, promise);
    }
}

