/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import reactor.netty.Metrics;
import reactor.netty.channel.MeterKey;
import reactor.netty.http.MicrometerHttpMetricsRecorder;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.internal.util.MapUtils;

final class MicrometerHttpServerMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpServerMetricsRecorder {
    static final MicrometerHttpServerMetricsRecorder INSTANCE = new MicrometerHttpServerMetricsRecorder();
    private static final String PROTOCOL_VALUE_HTTP = "http";
    private static final String ACTIVE_CONNECTIONS_DESCRIPTION = "The number of http connections currently processing requests";
    private final LongAdder activeConnectionsAdder = new LongAdder();
    private final ConcurrentMap<String, LongAdder> activeConnectionsCache = new ConcurrentHashMap<String, LongAdder>();

    private MicrometerHttpServerMetricsRecorder() {
        super("reactor.netty.http.server", PROTOCOL_VALUE_HTTP);
    }

    @Override
    public void recordDataReceivedTime(String uri, String method, Duration time) {
        MeterKey meterKey = new MeterKey(uri, null, method, null);
        Timer dataReceivedTime = (Timer)MapUtils.computeIfAbsent((Map)this.dataReceivedTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpServerMetricsRecorder.filter((Meter)Timer.builder((String)(this.name() + ".data.received.time")).description("Time spent in consuming incoming data").tags(new String[]{"uri", uri, "method", method}).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(String uri, String method, String status, Duration time) {
        MeterKey meterKey = new MeterKey(uri, null, method, status);
        Timer dataSentTime = (Timer)MapUtils.computeIfAbsent((Map)this.dataSentTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpServerMetricsRecorder.filter((Meter)Timer.builder((String)(this.name() + ".data.sent.time")).description("Time spent in sending outgoing data").tags(new String[]{"uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordResponseTime(String uri, String method, String status, Duration time) {
        MeterKey meterKey = new MeterKey(uri, null, method, status);
        Timer responseTime = (Timer)MapUtils.computeIfAbsent((Map)this.responseTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpServerMetricsRecorder.filter((Meter)Timer.builder((String)(this.name() + ".response.time")).description("Total time for the request/response").tags(new String[]{"uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (responseTime != null) {
            responseTime.record(time);
        }
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, String uri, long bytes) {
        MeterKey meterKey = new MeterKey(uri, null, null, null);
        DistributionSummary dataReceived = (DistributionSummary)MapUtils.computeIfAbsent((Map)this.dataReceivedCache, (Object)meterKey, key -> (DistributionSummary)MicrometerHttpServerMetricsRecorder.filter((Meter)DistributionSummary.builder((String)(this.name() + ".data.received")).baseUnit("bytes").description("Amount of the data received, in bytes").tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (dataReceived != null) {
            dataReceived.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, String uri, long bytes) {
        MeterKey meterKey = new MeterKey(uri, null, null, null);
        DistributionSummary dataSent = (DistributionSummary)MapUtils.computeIfAbsent((Map)this.dataSentCache, (Object)meterKey, key -> (DistributionSummary)MicrometerHttpServerMetricsRecorder.filter((Meter)DistributionSummary.builder((String)(this.name() + ".data.sent")).baseUnit("bytes").description("Amount of the data sent, in bytes").tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (dataSent != null) {
            dataSent.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, String uri) {
        MeterKey meterKey = new MeterKey(uri, null, null, null);
        Counter errors = (Counter)MapUtils.computeIfAbsent((Map)this.errorsCache, (Object)meterKey, key -> (Counter)MicrometerHttpServerMetricsRecorder.filter((Meter)Counter.builder((String)(this.name() + ".errors")).description("Number of errors that occurred").tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (errors != null) {
            errors.increment();
        }
    }

    @Override
    public void recordServerConnectionActive(SocketAddress localAddress) {
        LongAdder adder = this.getServerConnectionAdder(localAddress);
        if (adder != null) {
            adder.increment();
        }
    }

    @Override
    public void recordServerConnectionInactive(SocketAddress localAddress) {
        LongAdder adder = this.getServerConnectionAdder(localAddress);
        if (adder != null) {
            adder.decrement();
        }
    }

    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
    }

    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
    }

    public void incrementErrorsCount(SocketAddress remoteAddress) {
    }

    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
    }

    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        throw new UnsupportedOperationException();
    }

    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        throw new UnsupportedOperationException();
    }

    private LongAdder getServerConnectionAdder(SocketAddress localAddress) {
        String address = Metrics.formatSocketAddress((SocketAddress)localAddress);
        return (LongAdder)MapUtils.computeIfAbsent(this.activeConnectionsCache, (Object)address, key -> {
            Gauge gauge = (Gauge)MicrometerHttpServerMetricsRecorder.filter((Meter)Gauge.builder((String)"reactor.netty.http.server.connections.active", (Object)this.activeConnectionsAdder, LongAdder::longValue).tags(new String[]{"uri", PROTOCOL_VALUE_HTTP, "local.address", address}).description(ACTIVE_CONNECTIONS_DESCRIPTION).register(Metrics.REGISTRY));
            return gauge != null ? this.activeConnectionsAdder : null;
        });
    }
}

