/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.dvcs;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Encodable;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1OctetString;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Sequence;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.ContentInfo;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.SignedData;
import io.gatling.recorder.internal.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.cms.CMSSignedData;
import io.gatling.recorder.internal.bouncycastle.dvcs.DVCSConstructionException;
import io.gatling.recorder.internal.bouncycastle.dvcs.DVCSMessage;

public class DVCSResponse
extends DVCSMessage {
    private io.gatling.recorder.internal.bouncycastle.asn1.dvcs.DVCSResponse asn1;

    public DVCSResponse(CMSSignedData cMSSignedData) throws DVCSConstructionException {
        this(SignedData.getInstance(cMSSignedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSResponse(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSResponseData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Response");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? io.gatling.recorder.internal.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(contentInfo.getContent()) : io.gatling.recorder.internal.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception exception) {
            throw new DVCSConstructionException("Unable to parse content: " + exception.getMessage(), exception);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }
}

