/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.teamcityformatter;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ComparisonFailure {
    private static final Pattern[] COMPARE_PATTERNS = new Pattern[]{Pattern.compile("expected: (.*)(?:\r\n|\r|\n) {5}but: was (.*)$", 34), Pattern.compile("expected: (.*)(?:\r\n|\r|\n) but was: (.*)$", 34), Pattern.compile("expected: <(.*)> but was: <(.*)>$", 34), Pattern.compile("expected:\\s?<(.*)> but was:\\s?<(.*)>$", 34), Pattern.compile("expected \\[(.*)] but found \\[(.*)]$", 34)};
    private final String expected;
    private final String actual;

    static ComparisonFailure parse(String message) {
        for (Pattern pattern : COMPARE_PATTERNS) {
            ComparisonFailure result = ComparisonFailure.parse(message, pattern);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static ComparisonFailure parse(String message, Pattern pattern) {
        Matcher matcher = pattern.matcher(message);
        if (!matcher.find()) {
            return null;
        }
        String expected = matcher.group(1);
        String actual = matcher.group(2);
        return new ComparisonFailure(expected, actual);
    }

    ComparisonFailure(String expected, String actual) {
        this.expected = Objects.requireNonNull(expected);
        this.actual = Objects.requireNonNull(actual);
    }

    public String getExpected() {
        return this.expected;
    }

    public String getActual() {
        return this.actual;
    }
}

