/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.element.svg;

import java.util.ArrayList;
import java.util.List;
import org.vaadin.firitin.element.svg.SvgGraphicsElement;

public class PolygonElement
extends SvgGraphicsElement {
    private final List<double[]> pointsList = new ArrayList<double[]>();

    public PolygonElement() {
        super("polygon");
    }

    public PolygonElement points(String points) {
        this.pointsList.clear();
        this.setWriteOnlyAttribute("points", points);
        return this;
    }

    public PolygonElement pointsRW(String points) {
        this.pointsList.clear();
        this.setAttribute("points", points);
        return this;
    }

    public PolygonElement points(double ... coords) {
        if (coords.length % 2 != 0) {
            throw new IllegalArgumentException("Coordinates must be provided in pairs (x,y)");
        }
        this.pointsList.clear();
        for (int i = 0; i < coords.length; i += 2) {
            this.pointsList.add(new double[]{coords[i], coords[i + 1]});
        }
        this.updatePointsAttribute();
        return this;
    }

    public PolygonElement addPoint(double x, double y) {
        this.pointsList.add(new double[]{x, y});
        this.updatePointsAttribute();
        return this;
    }

    public PolygonElement addPoints(double ... coords) {
        if (coords.length % 2 != 0) {
            throw new IllegalArgumentException("Coordinates must be provided in pairs (x,y)");
        }
        for (int i = 0; i < coords.length; i += 2) {
            this.pointsList.add(new double[]{coords[i], coords[i + 1]});
        }
        this.updatePointsAttribute();
        return this;
    }

    public PolygonElement clearPoints() {
        this.pointsList.clear();
        this.setWriteOnlyAttribute("points", "");
        return this;
    }

    public PolygonElement pathLength(double pathLength) {
        this.setWriteOnlyAttribute("pathLength", String.valueOf(pathLength));
        return this;
    }

    public PolygonElement pathLengthRW(double pathLength) {
        this.setAttribute("pathLength", String.valueOf(pathLength));
        return this;
    }

    public PolygonElement regularPolygon(double cx, double cy, double radius, int sides) {
        if (sides < 3) {
            throw new IllegalArgumentException("A polygon must have at least 3 sides");
        }
        this.pointsList.clear();
        double angleStep = Math.PI * 2 / (double)sides;
        double startAngle = -1.5707963267948966;
        for (int i = 0; i < sides; ++i) {
            double angle = startAngle + (double)i * angleStep;
            double x = cx + radius * Math.cos(angle);
            double y = cy + radius * Math.sin(angle);
            this.pointsList.add(new double[]{x, y});
        }
        this.updatePointsAttribute();
        return this;
    }

    public PolygonElement triangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        return this.points(x1, y1, x2, y2, x3, y3);
    }

    public PolygonElement star(double cx, double cy, double outerRadius, double innerRadius, int points) {
        if (points < 3) {
            throw new IllegalArgumentException("A star must have at least 3 points");
        }
        this.pointsList.clear();
        double angleStep = Math.PI / (double)points;
        double startAngle = -1.5707963267948966;
        for (int i = 0; i < points * 2; ++i) {
            double angle = startAngle + (double)i * angleStep;
            double radius = i % 2 == 0 ? outerRadius : innerRadius;
            double x = cx + radius * Math.cos(angle);
            double y = cy + radius * Math.sin(angle);
            this.pointsList.add(new double[]{x, y});
        }
        this.updatePointsAttribute();
        return this;
    }

    private void updatePointsAttribute() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.pointsList.size(); ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            double[] point = this.pointsList.get(i);
            sb.append(point[0]).append(",").append(point[1]);
        }
        this.setWriteOnlyAttribute("points", sb.toString());
    }
}

