package fr.reseaumexico.editor;

import org.jdesktop.swingx.JXTable;

import fr.reseaumexico.model.Factor;

/*
 * #%L
 * JMexico :: Swing Editor
 * $Id: InputDesignTable.java 136 2014-07-23 14:41:50Z echatellier $
 * $HeadURL: https://svn.codelutin.com/jmexico/tags/jmexico-0.11/jmexico-editor/src/main/java/fr/reseaumexico/editor/InputDesignTable.java $
 * %%
 * Copyright (C) 2014 Réseau Mexico, Codelutin, Eric Chatellier
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * Surcharge pour pouvoir redefinir la méthode getStringAt et faire fonctionner la recherche.
 * 
 * @author Eric Chatellier
 */
public class InputDesignTable extends JXTable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1535729351105478070L;

    @Override
    public String getStringAt(int row, int column) {

        String result = null;
        
        if (column == 0) {
            // traduction du facteur
            Factor factor = (Factor)getValueAt(row, column);
            result = factor.getName();
        } else {
            result = super.getStringAt(row, column);
        }
        return result;
    }
}
