package fr.reseaumexico.editor;

/*
 * #%L
 * JMexico :: Swing Editor
 * %%
 * Copyright (C) 2011 - 2014 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ImportScenarioPanel extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_IMPORT_FILE_EDITOR_SELECTED_FILE = "importFileEditor.selectedFile";
    public static final String BINDING_SCENARIO_NAME_EDITOR_TEXT = "scenarioNameEditor.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TTW8TMRCdhCYlaaFfIrSiiEKRoBycH1AERYWIVikgwqEiF5ys27hydo3tpVshED+BnwB3LkjcOCEOnDlwQfwFhDhwRYydzW7TbmlyWEX2vDdvxu+9+wkFreDiDo0iokLf8C4j67c2N++3dljb3Ga6rbg0gYLeL5eHfBPGvORcG1hs1i28GsOrq0FXBj7z96GX61DWZk8w3WHMGDg/iGhrXW0k18uRDFWfNRGVxfrm96/8a+/V2zxAJFFdEUdZOA6VTjJShzz3DExjp2e0Kqi/jTIU97dR7yl7tiqo1vdolz2FlzBah6KkCskMXBp+ZMfh8JE0UJDUZ8LAtS1FFNOMhl0W8XZAmMcRRdaQSJlGm/lU8eCBLZbSwYsI7gbe8OANW5yCJ7i7rXHB6rRlaabtiBHRuzgxWXeHtraUQCZTyB3XwcDlgfX2oHH3tGyQZUrHguwiky5Tg0XT+4v6zSoDAh+xCKUw4cVIBecGxKCLSOqi9JlzTSioEI8NzDYPG+8hXvUsN3vAcpbQ3f6tzHz7+ONDre8zG5kzmaX7YoLvL1UgmTLctp7omSw0XFQ3qFxuQkkzgRlzGZrPENaIr1Ec9puycGLh5C7VHaQojH7/9Lny5OsJyNegLALq1aitX4OS6aA9OoHwInlzxSka3z2J30mrzcCIwVWiiXdi+wj7KKT/AqT36sTHl4hwLfMZa0m0tUpf/sw03q/0V5NDqXNHlqfrKTyGIvcF95kLYZyvzNCNSc1CL0hzlJUsyPKZjN1/wX0X/7OKuecuWmSbJfGxLFeXXkShxV5xo9l/S5Bp1uFbHbP1LUxRVs+D8R2i4XjPYMyzIANn0xnXEq4jJjyU/CHaFQXdC0Kc8PR1jxq60OK+h8G9cYg/Z79lZPwHt7Niw34GAAA=";
    private static final Log log = LogFactory.getLog(ImportScenarioPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected FileEditor importFileEditor;
    protected JLabel importFileLabel;
    protected ImportScenarioModel model;
    protected ImportScenarioPanel panel = this;
    protected JTextField scenarioNameEditor;
    protected JLabel scenarioNameLabel;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(ImportScenarioModel model) {
        model.copyTo(this.model);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ImportScenarioPanel() {
        $initialize();
    }

    public ImportScenarioPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__importFileEditor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setImportFile(((FileEditor) event.getSource()).getSelectedFile());
    }

    public void doKeyReleased__on__scenarioNameEditor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setScenarioName(((JTextField)event.getSource()).getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public FileEditor getImportFileEditor() {
        return importFileEditor;
    }

    public JLabel getImportFileLabel() {
        return importFileLabel;
    }

    public ImportScenarioModel getModel() {
        return model;
    }

    public JTextField getScenarioNameEditor() {
        return scenarioNameEditor;
    }

    public JLabel getScenarioNameLabel() {
        return scenarioNameLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(importFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(importFileEditor, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(scenarioNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(scenarioNameEditor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createImportFileEditor() {
        $objectMap.put("importFileEditor", importFileEditor = new FileEditor());
        
        importFileEditor.setName("importFileEditor");
        importFileEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importFileEditor"));
    }

    protected void createImportFileLabel() {
        $objectMap.put("importFileLabel", importFileLabel = new JLabel());
        
        importFileLabel.setName("importFileLabel");
        importFileLabel.setText(_("jmexico.label.scenario.import.file"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new ImportScenarioModel());
    }

    protected void createScenarioNameEditor() {
        $objectMap.put("scenarioNameEditor", scenarioNameEditor = new JTextField());
        
        scenarioNameEditor.setName("scenarioNameEditor");
        scenarioNameEditor.setColumns(15);
        scenarioNameEditor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__scenarioNameEditor"));
    }

    protected void createScenarioNameLabel() {
        $objectMap.put("scenarioNameLabel", scenarioNameLabel = new JLabel());
        
        scenarioNameLabel.setName("scenarioNameLabel");
        scenarioNameLabel.setText(_("jmexico.label.scenario.import.name"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToPanel();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("panel", panel);
        createModel();
        createImportFileLabel();
        createImportFileEditor();
        createScenarioNameLabel();
        createScenarioNameEditor();
        // inline creation of panel
        setName("panel");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_FILE_EDITOR_SELECTED_FILE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importFileEditor.setSelectedFile(model.getImportFile());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SCENARIO_NAME_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("scenarioName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(scenarioNameEditor, model.getScenarioName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("scenarioName", this);
                }
            }
        });
    }

}