/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.tripMap;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.legend.Drawer;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.simple.SimpleFeature;

public class ObserverMapPanLegendDrawer {
    protected Drawer drawer = Drawer.create();

    public void drawDirect(BufferedImage bi, SimpleFeature feature, Rule rule) {
        AffineTransform affineTransform = new AffineTransform();
        LiteShape shape = new LiteShape(null, affineTransform, false);
        for (Symbolizer symbolizer : rule.getSymbolizers()) {
            if (symbolizer instanceof LineSymbolizer) {
                LineSymbolizer lineSymbolizer = (LineSymbolizer)symbolizer;
                Geometry geometry = this.findGeometry(feature, lineSymbolizer);
                if (geometry == null) continue;
                Graphics graphics = bi.getGraphics();
                Graphics2D g = (Graphics2D)graphics;
                shape.setGeometry(geometry);
                Color c = SLD.color((LineSymbolizer)lineSymbolizer);
                int w = SLD.width((LineSymbolizer)lineSymbolizer);
                float[] lineDash = SLD.lineDash((LineSymbolizer)lineSymbolizer);
                if (c == null || w <= 0) continue;
                g.setColor(c);
                BasicStroke str = new BasicStroke(w, 2, 0, 10.0f, lineDash, 0.0f);
                g.setStroke(str);
                g.draw((Shape)shape);
                continue;
            }
            this.drawer.drawFeature(bi, feature, affineTransform, false, symbolizer, null, shape);
        }
    }

    protected Geometry findGeometry(SimpleFeature feature, LineSymbolizer lineSymbolizer) {
        String geomName = lineSymbolizer.getGeometryPropertyName();
        Geometry geom = geomName == null ? (Geometry)feature.getDefaultGeometry() : (Geometry)feature.getAttribute(geomName);
        return geom;
    }
}

