/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.table;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ObserveBooleanTableCellRenderer
extends JCheckBox
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected final TableCellRenderer defaultDelegate;
    private final Predicate predicate;
    private static final Predicate<Object> DEFAULT_PREDICATE = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input != null && (Boolean)input != false;
        }
    };

    public ObserveBooleanTableCellRenderer(TableCellRenderer delegate, Predicate<?> predicate) {
        this(delegate, null, predicate);
    }

    public ObserveBooleanTableCellRenderer(TableCellRenderer delegate) {
        this(delegate, DEFAULT_PREDICATE);
    }

    public ObserveBooleanTableCellRenderer(TableCellRenderer delegate, Icon icon, Predicate<?> predicate) {
        this.defaultDelegate = delegate;
        this.predicate = predicate;
        this.setOpaque(true);
        this.setBorderPainted(true);
        this.setHorizontalAlignment(0);
        this.setIcon(icon);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ((JComponent)((Object)this.defaultDelegate)).setBackground(null);
        JComponent render = (JComponent)this.defaultDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(render.getForeground());
            this.setBackground(render.getBackground());
            if (row % 2 == 0) {
                this.setBackground(Color.WHITE);
            }
        }
        boolean selectCheckBox = this.predicate.apply(value);
        this.setSelected(selectCheckBox);
        this.setBorder(render.getBorder());
        return this;
    }
}

