/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.longline.LonglineGlobalCompositionUI;
import fr.ird.observe.ui.content.impl.longline.LonglineGlobalCompositionUIModel;
import fr.ird.observe.ui.content.table.ContentTableUI;
import java.awt.Component;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public class LonglineGlobalCompositionUIHandler
extends ContentUIHandler<SetLongline> {
    private static Log log = LogFactory.getLog(LonglineGlobalCompositionUIHandler.class);

    public LonglineGlobalCompositionUIHandler(LonglineGlobalCompositionUI ui) {
        super(ui, DataContextType.ActivityLongline, DataContextType.SetLongline);
    }

    public LonglineGlobalCompositionUI getUi() {
        return (LonglineGlobalCompositionUI)super.getUi();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        if (dataContext.isSelectedOpen(ActivityLongline.class)) {
            return ContentMode.UPDATE;
        }
        LonglineGlobalCompositionUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(ActivityLongline.class), I18n.t((String)"observe.activityLongline.message.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void initUI() throws Exception {
        super.initUI();
        ContentTableUI compositionUI = this.getUi().getFloatlinesCompositionUI();
        compositionUI.init();
        this.getUi().getFloatlinesCompositionPanel().remove((Component)((Object)compositionUI));
        this.getUi().getFloatlinesCompositionPanel().add(compositionUI.getBody());
        compositionUI = this.getUi().getBranchlinesCompositionUI();
        compositionUI.init();
        this.getUi().getBranchlinesCompositionPanel().remove((Component)((Object)compositionUI));
        this.getUi().getBranchlinesCompositionPanel().add(compositionUI.getBody());
        compositionUI = this.getUi().getHooksCompositionUI();
        compositionUI.init();
        this.getUi().getHooksCompositionPanel().remove((Component)((Object)compositionUI));
        this.getUi().getHooksCompositionPanel().add(compositionUI.getBody());
        compositionUI = this.getUi().getBaitsCompositionUI();
        compositionUI.init();
        this.getUi().getBaitsCompositionPanel().remove((Component)((Object)compositionUI));
        this.getUi().getBaitsCompositionPanel().add(compositionUI.getBody());
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activityId = this.getSelectedParentId();
        String setId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activityId = " + activityId));
            log.info((Object)("setId      = " + setId));
        }
        ContentMode mode = this.computeContentMode();
        DataService dataService = this.getDataService();
        DataSource source = this.getDataSource();
        dataService.loadEditEntity(source, setId, this.getLoadExecutor());
        this.setContentMode(mode);
        if (mode != ContentMode.READ) {
            this.getUi().startEdit(null);
        }
        ContentTableUI compositionUI = this.getUi().getFloatlinesCompositionUI();
        compositionUI.open();
        compositionUI = this.getUi().getBranchlinesCompositionUI();
        compositionUI.open();
        compositionUI = this.getUi().getHooksCompositionUI();
        compositionUI.open();
        compositionUI = this.getUi().getBaitsCompositionUI();
        compositionUI.open();
    }

    @Override
    public void startEditUI(String ... binding) {
        LonglineGlobalCompositionUIModel model = (LonglineGlobalCompositionUIModel)this.getModel();
        this.addInfoMessage(I18n.t((String)"observe.longlineGlobalComposition.message.updating", (Object[])new Object[0]));
        super.startEditUI("comment2.text");
        model.setModified(false);
    }

    @Override
    protected boolean doSave(SetLongline bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<SetLongline> binder) throws Exception {
        dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected SetLongline onUpdate(TopiaContext tx, Object parentBean, SetLongline beanToSave) throws TopiaException {
        beanToSave.setComment(((SetLongline)this.getBean()).getComment());
        beanToSave.clearMitigationType();
        beanToSave.addAllMitigationType(((SetLongline)this.getBean()).getMitigationType());
        this.getUi().getFloatlinesCompositionUI().getHandler().onUpdate(tx, parentBean, beanToSave);
        this.getUi().getBranchlinesCompositionUI().getHandler().onUpdate(tx, parentBean, beanToSave);
        this.getUi().getHooksCompositionUI().getHandler().onUpdate(tx, parentBean, beanToSave);
        this.getUi().getBaitsCompositionUI().getHandler().onUpdate(tx, parentBean, beanToSave);
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        super.afterSave(refresh);
        this.getUi().getFloatlinesCompositionUI().getHandler().afterSave(refresh);
        this.getUi().getBranchlinesCompositionUI().getHandler().afterSave(refresh);
        this.getUi().getHooksCompositionUI().getHandler().afterSave(refresh);
        this.getUi().getBaitsCompositionUI().getHandler().afterSave(refresh);
    }
}

