/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.table;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AbstractEditableTableModel<E extends TopiaEntity>
extends AbstractTableModel {
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String EMPTY_PROPERTY = "empty";
    public static final String MODIFIED_PROPERTY = "modified";
    public static final String SELECTED_ROW_PROPERTY = "selectedRow";
    private static final long serialVersionUID = 1L;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected boolean editable;
    protected boolean modified;
    protected int selectedRow = -1;
    protected List<E> data = new ArrayList();

    protected abstract E createNewRow();

    public List<E> getData() {
        return this.data;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    public void setData(List<E> data) {
        this.data.clear();
        this.data.addAll(data);
        if (this.data.isEmpty() && this.editable) {
            this.addNewRow();
        }
        this.setSelectedRow(this.isEmpty() ? -1 : 0);
        this.fireTableDataChanged();
    }

    public void addNewRow() {
        this.ensureEditable();
        int row = this.getRowCount();
        E bean = this.createNewRow();
        this.data.add(bean);
        this.fireTableRowsInserted(row, row);
        this.updateEmpty();
        this.setSelectedRow(row);
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int selectedRow) {
        int old = this.selectedRow;
        this.selectedRow = selectedRow;
        this.firePropertyChange(SELECTED_ROW_PROPERTY, old, selectedRow);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.firePropertyChange(MODIFIED_PROPERTY, null, modified);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void updateEmpty() {
        this.firePropertyChange(EMPTY_PROPERTY, null, this.isEmpty());
    }

    protected void ensureEditable() throws IllegalStateException {
        if (!this.editable) {
            throw new IllegalStateException("can not edit this model since it is marked as none editable " + this);
        }
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }
}

