/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.ReferenceEntities;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.Species2;
import fr.ird.observe.entities.referentiel.seine.WeightCategory;
import fr.ird.observe.entities.seine.SetSeine;
import fr.ird.observe.entities.seine.TargetCatch;
import fr.ird.observe.entities.seine.TargetLength;
import fr.ird.observe.entities.seine.TargetSample;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.seine.TargetCatchUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class TargetCatchUIHandler
extends ContentTableUIHandler<SetSeine, TargetCatch> {
    private static final Log log = LogFactory.getLog(TargetCatchUIHandler.class);
    JAXXContextEntryDef<List<TargetLength>> ALL_TAILLES_TO_DELETE_ENTRY = UIHelper.newListContextEntryDef((String)"TargetCatchUI-all-taille-to-delete");
    JAXXContextEntryDef<List<WeightCategory>> ALL_CATEGORIES_ENTRY = UIHelper.newListContextEntryDef((String)"TargetCatchUI-all-categories");
    TopiaExecutor<WeightCategory> weightCategoryTopiaExecutor = new TopiaExecutor<WeightCategory>(){

        public void execute(TopiaContext tx, WeightCategory bean) {
            TargetCatchUIHandler.this.getDecoratorService().decorate((Object)bean.getSpecies());
        }
    };

    public TargetCatchUIHandler(TargetCatchUI ui) {
        super(ui, DataContextType.SetSeine);
    }

    @Override
    public TargetCatchUI getUi() {
        return (TargetCatchUI)super.getUi();
    }

    @Override
    public void initUI() throws Exception {
        super.initUI();
        this.getUi().getSpecies().addPropertyChangeListener("selectedItem", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContentTableModel model = TargetCatchUIHandler.this.getTableModel();
                if (((TargetCatch)model.getRowBean()).getTopiaId() == null) {
                    Species species = (Species)evt.getNewValue();
                    TargetCatchUIHandler.this.onEspeceChanged(species);
                }
            }
        });
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedSetId();
    }

    @Override
    protected SetSeine loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        List speciesList;
        List categorieList;
        if (mode == ContentMode.UPDATE) {
            categorieList = new ArrayList(dataService.loadDecoratedEntities(dataSource, WeightCategory.class, this.weightCategoryTopiaExecutor));
            ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
            String speciesListId = config.getSpeciesListSeineTargetCatch();
            Set speciesIds = this.getDataService().getSpeciesListSpeciesIds(this.getDataSource(), speciesListId);
            categorieList = Species2.filterWeightCategoryBySpeciesIds(categorieList, (Set)speciesIds);
            ReferenceEntities.filterReferentielListByStatus(categorieList);
            Ocean ocean = dataService.getTripOcean(dataSource, dataContext.getSelectedTripId());
            categorieList = Species2.filterWeightCategoryByOcean(categorieList, (Ocean)ocean);
            speciesList = Species2.toSpecies(categorieList);
            ReferenceEntities.filterReferentielListByStatus(speciesList);
        } else {
            speciesList = new ArrayList();
            categorieList = new ArrayList();
        }
        TargetCatchUI ui = this.getUi();
        this.ALL_CATEGORIES_ENTRY.setContextValue((JAXXContext)ui, categorieList);
        ui.getSpecies().setData(speciesList);
        return (SetSeine)super.loadEditBean(mode, dataContext, dataService, dataSource);
    }

    @Override
    protected Collection<TargetCatch> loadChilds(TopiaContext tx, SetSeine bean) throws TopiaException {
        Collection childs = ((ContentTableUIModel)this.getModel()).getChildsUpdator().getChilds((TopiaEntity)bean);
        ArrayList<TargetCatch> data = new ArrayList<TargetCatch>();
        if (CollectionUtils.isNotEmpty((Collection)childs)) {
            TopiaDAO dao = this.getDataSource().getDAO(tx, this.getTableEditBean());
            TopiaEntityBinder childLoador = ((ContentTableUIModel)this.getModel()).getChildLoador();
            DecoratorService decoratorService = this.getDecoratorService();
            for (TargetCatch c : childs) {
                if (c.isDiscarded()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("targetDiscarded " + c.getSpecies().getLabel2() + " non retenu."));
                    continue;
                }
                try {
                    TargetCatch c2 = (TargetCatch)((ContentTableUIModel)this.getModel()).newTableEditBean();
                    TargetCatch safeC = (TargetCatch)dao.findByTopiaId(c.getTopiaId());
                    WeightCategory weightCategory = safeC.getWeightCategory();
                    if (weightCategory != null) {
                        Species species = weightCategory.getSpecies();
                        decoratorService.decorate((Object)species);
                    }
                    childLoador.load((TopiaEntity)safeC, (TopiaEntity)c2, true, new String[0]);
                    data.add(c2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return data;
    }

    @Override
    protected boolean prepareSave(SetSeine bean, List<TargetCatch> objets) throws DataSourceException {
        HashSet<Species> speciessUsed = new HashSet<Species>();
        for (TargetCatch c : objets) {
            speciessUsed.add(c.getSpecies());
        }
        ArrayList tailleToDelete = new ArrayList();
        HashSet speciessToDelete = new HashSet();
        this.getDataService().getObsoleteEspeceForTargetSample(this.getDataSource(), bean.getTopiaId(), speciessUsed, speciessToDelete, tailleToDelete, true);
        if (!tailleToDelete.isEmpty()) {
            StringBuilder sb = new StringBuilder(512);
            StringBuilder sb2 = new StringBuilder(512);
            Decorator decorator = this.getDecoratorService().getDecoratorByType(Species.class);
            Decorator decorator2 = this.getDecoratorService().getDecoratorByType(TargetLength.class);
            for (Species e : speciessToDelete) {
                sb.append("  - ").append(decorator.toString((Object)e)).append('\n');
            }
            for (TargetLength t : tailleToDelete) {
                sb2.append("  - ").append(decorator2.toString((Object)t)).append('\n');
            }
            int reponse = UIHelper.askUser(I18n.t((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n.t((String)"observe.message.targetDiscarded.table.will.delete.targetLength", (Object[])new Object[]{sb.toString(), sb2.toString()}), 0, new Object[]{I18n.t((String)"observe.choice.continue", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            boolean canContinue = false;
            switch (reponse) {
                case 0: {
                    canContinue = true;
                }
            }
            if (!canContinue) {
                return false;
            }
            this.ALL_TAILLES_TO_DELETE_ENTRY.setContextValue((JAXXContext)this.getUi(), tailleToDelete);
        }
        for (TargetCatch targetCatch : objets) {
            targetCatch.setSetSeine(bean);
        }
        return true;
    }

    @Override
    protected void onUpdateFinalize(TopiaContext tx, SetSeine bean, Collection<TargetCatch> oldChilds) {
        List tailleToDelete;
        if (oldChilds != null && !oldChilds.isEmpty()) {
            for (TargetCatch targetCatch : oldChilds) {
                if (!targetCatch.isDiscarded()) continue;
                bean.addTargetCatch(targetCatch);
            }
        }
        if ((tailleToDelete = (List)this.ALL_TAILLES_TO_DELETE_ENTRY.getContextValue((JAXXContext)this.getUi())) != null && !tailleToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will remove " + tailleToDelete.size() + " obsolete targetLength(s)."));
            }
            TargetSample echantillon = bean.getTargetSample(true);
            echantillon.getTargetLength().removeAll(tailleToDelete);
        }
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, TargetCatch bean, boolean create) {
        NumberEditor requestFocus;
        Species beanEspece;
        TargetCatchUI ui = this.getUi();
        WeightCategory beanWeightCategory = bean.getWeightCategory();
        Species species = beanEspece = beanWeightCategory == null ? null : beanWeightCategory.getSpecies();
        if (create) {
            ui.getSpecies().setSelectedItem(null);
            if (!this.getTableModel().isCreate()) {
                ui.getSpecies().setSelectedItem((Object)beanEspece);
                ui.getWeightCategory().setSelectedItem((Object)beanWeightCategory);
            }
            requestFocus = ui.getSpecies();
        } else {
            ui.getSpecies().setSelectedItem((Object)beanEspece);
            ui.getWeightCategory().setData(Arrays.asList(beanWeightCategory));
            ui.getWeightCategory().setSelectedItem((Object)beanWeightCategory);
            requestFocus = ui.getCatchWeight();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected categoriePoid " + beanWeightCategory));
            log.debug((Object)("selected species " + beanEspece));
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)2, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)50);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)50);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.targetCatch.table.speciesThon", (Object[])new Object[0]), I18n.n((String)"observe.targetCatch.table.speciesThon.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetCatch.table.weightCategory", (Object[])new Object[0]), I18n.n((String)"observe.targetCatch.table.weightCategory.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetCatch.table.well", (Object[])new Object[0]), I18n.n((String)"observe.targetCatch.table.well.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetCatch.table.weight", (Object[])new Object[0]), I18n.n((String)"observe.targetCatch.table.weight.tip", (Object[])new Object[0]), I18n.n((String)"observe.targetCatch.table.comment", (Object[])new Object[0]), I18n.n((String)"observe.targetCatch.table.comment.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, WeightCategory.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)renderer);
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    protected void onEspeceChanged(Species species) {
        List<Object> availableCategories;
        if (species == null) {
            availableCategories = Collections.emptyList();
        } else {
            availableCategories = this.getAllCategories((JAXXContext)this.getUi());
            Iterator<Object> it = availableCategories.iterator();
            while (it.hasNext()) {
                WeightCategory weighte = (WeightCategory)it.next();
                if (species.equals(weighte.getSpecies())) continue;
                it.remove();
            }
        }
        BeanComboBox<WeightCategory> combo = this.getUi().getWeightCategory();
        combo.setData(availableCategories);
        combo.setSelectedItem(null);
    }

    protected List<WeightCategory> getAllCategories(JAXXContext context) {
        ArrayList<WeightCategory> list = new ArrayList<WeightCategory>((Collection)this.ALL_CATEGORIES_ENTRY.getContextValue(context));
        return list;
    }
}

