/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import com.google.common.base.Predicate;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import fr.ird.observe.DataService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.Basket;
import fr.ird.observe.entities.longline.Branchline;
import fr.ird.observe.entities.longline.Section;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.entities.longline.Tdr;
import fr.ird.observe.entities.referentiel.Species2;
import fr.ird.observe.entities.referentiel.longline.SensorBrand;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.impl.longline.TdrUI;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.sql.rowset.serial.SerialBlob;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JaxxFileChooser;

public class TdrUIHandler
extends ContentTableUIHandler<SetLongline, Tdr> {
    private static Log log = LogFactory.getLog(TdrUIHandler.class);
    protected boolean locationIsAdjusting;
    protected final PropertyChangeListener sectionChanged = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TdrUIHandler.this.locationIsAdjusting = true;
            try {
                Section oldValue = (Section)evt.getOldValue();
                Section newValue = (Section)evt.getNewValue();
                TdrUI ui = TdrUIHandler.this.getUi();
                Tdr tableEditBean = (Tdr)evt.getSource();
                Basket basket = tableEditBean.getBasket();
                Branchline branchline = tableEditBean.getBranchline();
                if (newValue == null) {
                    ui.getBasket().setData(Collections.emptyList());
                    ui.getBranchline().setData(Collections.emptyList());
                    tableEditBean.setBasket(null);
                    tableEditBean.setBranchline(null);
                } else {
                    ui.getBranchline().setData(Collections.emptyList());
                    tableEditBean.setBasket(null);
                    tableEditBean.setBranchline(null);
                }
            }
            finally {
                TdrUIHandler.this.locationIsAdjusting = false;
            }
        }
    };
    protected final PropertyChangeListener basketChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!TdrUIHandler.this.locationIsAdjusting) {
                Basket oldValue = (Basket)evt.getNewValue();
                Basket newValue = (Basket)evt.getNewValue();
                TdrUI ui = TdrUIHandler.this.getUi();
                Tdr tableEditBean = (Tdr)evt.getSource();
                Branchline branchline = tableEditBean.getBranchline();
                if (newValue == null) {
                    ui.getBranchline().setData(Collections.emptyList());
                } else {
                    ui.getBranchline().setData(Collections.emptyList());
                }
                tableEditBean.setBranchline(null);
            }
        }
    };
    JAXXContextEntryDef<List<Section>> ALL_SECTIONS_ENTRY = UIHelper.newListContextEntryDef((String)"TdrUI-all-sections");

    public TdrUIHandler(TdrUI ui) {
        super(ui, DataContextType.SetLongline);
    }

    @Override
    public TdrUI getUi() {
        return (TdrUI)super.getUi();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, Tdr bean, boolean create) {
        ContentTableModel model = this.getTableModel();
        if (!model.isEditable()) {
            return;
        }
        String homeId = bean.getHomeId();
        TdrUI ui = this.getUi();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected tdr " + homeId));
        }
        JTextField requestFocus = ui.getHomeId();
        Tdr tableEditBean = (Tdr)this.getTableEditBean();
        tableEditBean.removePropertyChangeListener("section", this.sectionChanged);
        tableEditBean.addPropertyChangeListener("section", this.sectionChanged);
        tableEditBean.removePropertyChangeListener("basket", this.basketChanged);
        tableEditBean.addPropertyChangeListener("basket", this.basketChanged);
        if (create) {
            SetLongline setLongline = (SetLongline)this.getBean();
            Date settingStartTimeStamp = setLongline.getSettingStartTimeStamp();
            tableEditBean.setDeployementStart(settingStartTimeStamp);
            tableEditBean.setDeployementEnd(settingStartTimeStamp);
            tableEditBean.setFishingStart(settingStartTimeStamp);
            tableEditBean.setFishingEnd(settingStartTimeStamp);
            ui.getEditTabPane().setSelectedIndex(0);
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.tdr.table.homeId", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.homeId.tip", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.serialNo", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.serialNo.tip", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.sensorBrand", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.sensorBrand.tip", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.data", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.data.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, SensorBrand.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((TableCellRenderer)renderer, (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return input != null;
            }
        }));
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedSetId();
    }

    @Override
    public void initUI() throws Exception {
        ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
        String speciesListId = config.getSpeciesListLonglineCatch();
        Set speciesIds = this.getDataService().getSpeciesListSpeciesIds(this.getDataSource(), speciesListId);
        this.getUi().getSpecies().putClientProperty((Object)"listPredicate", (Object)Species2.newSpeciesByIdPredicate((Set)speciesIds));
        super.initUI();
    }

    @Override
    protected SetLongline loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        SetLongline setLongline = (SetLongline)super.loadEditBean(mode, dataContext, dataService, dataSource);
        List sectionList = dataService.getSections(dataSource, setLongline.getTopiaId());
        if (!setLongline.isSectionEmpty()) {
            sectionList.addAll(setLongline.getSection());
        }
        this.ALL_SECTIONS_ENTRY.setContextValue((JAXXContext)this.getUi(), (Object)sectionList);
        return setLongline;
    }

    public void importData() {
        File file = UIHelper.chooseFile((Component)((Object)this.ui), I18n.t((String)"observe.title.choose.tdr.importData", (Object[])new Object[0]), I18n.t((String)"observe.action.choose.tdr.importData", (Object[])new Object[0]), null, new String[0]);
        if (file != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Set data from file: " + file));
            }
            try {
                byte[] fileContent = FileUtils.readFileToByteArray((File)file);
                SerialBlob serialBlob = new SerialBlob(fileContent);
                ((Tdr)this.getTableEditBean()).setData((Blob)serialBlob);
                ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
                mainUI.getStatus().setStatus(I18n.t((String)"observe.tdr.message.data.imported", (Object[])new Object[]{file}));
            }
            catch (IOException e) {
                throw new ObserveTechnicalException("Could not read file: " + file, (Throwable)e);
            }
            catch (SQLException e) {
                throw new ObserveTechnicalException("Could not create binary data from file: " + file, (Throwable)e);
            }
        }
    }

    public void deleteData() {
        boolean doDelete;
        int response = UIHelper.askUser((Component)((Object)this.ui), I18n.t((String)"observe.title.delete", (Object[])new Object[0]), I18n.t((String)"observe.tdr.delete.data.message", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.choice.confirm.delete", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 1);
        boolean bl = doDelete = response == 0;
        if (doDelete) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete tdr data " + ((Tdr)this.getTableEditBean()).getData()));
            }
            ((Tdr)this.getTableEditBean()).setData(null);
        }
    }

    public void exportData() {
        File file = JaxxFileChooser.forSaving().setParent((Component)((Object)this.getUi())).setTitle(I18n.t((String)"observe.title.choose.tdr.exportData", (Object[])new Object[0])).setApprovalText(I18n.t((String)"observe.action.choose.tdr.exportData", (Object[])new Object[0])).setFilename("tdr-" + ((Tdr)this.getTableEditBean()).getSerialNo()).setUseAcceptAllFileFilter(true).choose();
        if (file != null) {
            InputStream binaryStream;
            if (log.isInfoEnabled()) {
                log.info((Object)("save tdr data to " + file));
            }
            try {
                binaryStream = ((Tdr)this.getTableEditBean()).getData().getBinaryStream();
            }
            catch (SQLException e) {
                throw new ObserveTechnicalException("Could not read binary data", (Throwable)e);
            }
            OutputStream outputstream = null;
            try {
                outputstream = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).openBufferedStream();
                IOUtils.copy((InputStream)binaryStream, (OutputStream)outputstream);
                outputstream.close();
                ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
                mainUI.getStatus().setStatus(I18n.t((String)"observe.sensorUsed.message.data.exported", (Object[])new Object[]{file}));
            }
            catch (IOException e) {
                try {
                    throw new ObserveTechnicalException("Could not save binary data to " + file, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputstream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)outputstream);
        }
    }
}

