/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.CatchLongline;
import fr.ird.observe.entities.longline.LonglinePositionAware;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.entities.longline.SizeMeasure;
import fr.ird.observe.entities.longline.SizeMeasureDAO;
import fr.ird.observe.entities.longline.WeightMeasure;
import fr.ird.observe.entities.longline.WeightMeasureDAO;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.longline.CatchFateLongline;
import fr.ird.observe.entities.referentiel.longline.Healthness;
import fr.ird.observe.entities.referentiel.longline.SizeMeasureType;
import fr.ird.observe.entities.referentiel.longline.WeightMeasureType;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIInitializer;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.impl.longline.CatchAcquisitionModeEnum;
import fr.ird.observe.ui.content.table.impl.longline.CatchLonglineTableModel;
import fr.ird.observe.ui.content.table.impl.longline.CatchLonglineUI;
import fr.ird.observe.ui.content.table.impl.longline.CatchLonglineUIModel;
import fr.ird.observe.ui.content.table.impl.longline.LonglinePositionHelper;
import fr.ird.observe.ui.content.table.impl.longline.SizeMeasuresTableModel;
import fr.ird.observe.ui.content.table.impl.longline.WeightMeasuresTableModel;
import fr.ird.observe.ui.util.table.EditableTableWithCacheTableModelSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public class CatchLonglineUIHandler
extends ContentTableUIHandler<SetLongline, CatchLongline> {
    private static Log log = LogFactory.getLog(CatchLonglineUIHandler.class);
    private final PropertyChangeListener catchFateChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CatchLonglineUIHandler.this.onCatchFateChanged((CatchFateLongline)evt.getNewValue(), (CatchLongline)evt.getSource());
        }
    };
    private final PropertyChangeListener depredatedChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CatchLonglineUIHandler.this.onDepretadedChanged((Boolean)evt.getNewValue(), (CatchLongline)evt.getSource());
        }
    };
    private final PropertyChangeListener sizeTableModelModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CatchLonglineUIHandler.this.onSizeTableModelModified((Boolean)evt.getNewValue());
        }
    };
    private final PropertyChangeListener weightTableModelModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CatchLonglineUIHandler.this.onWeightTableModelModified((Boolean)evt.getNewValue());
        }
    };
    protected final TableModelListener computeTabValidStateListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            SwingValidatorMessageTableModel source = (SwingValidatorMessageTableModel)e.getSource();
            CatchLonglineUIHandler.this.computeTabValidState(source);
        }
    };
    JAXXContextEntryDef<LonglinePositionHelper<CatchLongline>> POSITION_HELPER_ENTRY = UIHelper.newContextEntryDef((String)"CatchLonglineUI-positionHelper", LonglinePositionHelper.class);

    public CatchLonglineUIHandler(CatchLonglineUI ui) {
        super(ui, DataContextType.SetLongline);
    }

    @Override
    public CatchLonglineUI getUi() {
        return (CatchLonglineUI)super.getUi();
    }

    @Override
    public CatchLonglineUIModel getModel() {
        return (CatchLonglineUIModel)super.getModel();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, CatchLongline bean, boolean create) {
        BeanComboBox<Healthness> requestFocus;
        List weights;
        List sizes;
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected row changed: " + editingRow + ", create? " + create));
        }
        CatchLonglineUI ui = this.getUi();
        UIHelper.stopEditing(ui.getSizeMeasuresTable());
        UIHelper.stopEditing(ui.getWeightMeasuresTable());
        CatchLonglineTableModel tableModel = this.getTableModel();
        CatchLonglineUIModel model = this.getModel();
        boolean emptySelection = editingRow == -1;
        SizeMeasuresTableModel sizeMeasuresTableModel = model.getSizeMeasuresTableModel();
        List list = sizes = emptySelection ? Collections.emptyList() : sizeMeasuresTableModel.getCacheForRow(editingRow);
        if (sizes == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("init size measures for row " + editingRow));
            }
            if (tableModel.isCreate()) {
                sizes = Collections.emptyList();
                if (log.isInfoEnabled()) {
                    log.info((Object)"create mode, use an empty list");
                }
            } else {
                try {
                    sizes = this.getDataService().getCatchLonglineSizeMeasures(this.getDataSource(), bean, sizeMeasuresTableModel.getLoader());
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Loaded sizes (" + bean.getTopiaId() + "): " + sizes.size()));
                    }
                }
                catch (DataSourceException e) {
                    throw new ObserveTechnicalException("Could not load size measures", (Throwable)e);
                }
            }
            sizeMeasuresTableModel.initCacheForRow(editingRow, sizes);
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Using existing sizes for row " + editingRow + " : " + sizes.size()));
        }
        sizeMeasuresTableModel.setData(sizes);
        WeightMeasuresTableModel weightMeasuresTableModel = model.getWeightMeasuresTableModel();
        List list2 = weights = emptySelection ? Collections.emptyList() : weightMeasuresTableModel.getCacheForRow(editingRow);
        if (weights == null) {
            if (tableModel.isCreate()) {
                weights = Collections.emptyList();
            } else {
                try {
                    weights = this.getDataService().getCatchLonglineWeightMeasures(this.getDataSource(), bean, weightMeasuresTableModel.getLoader());
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Loaded weights (" + bean.getTopiaId() + "): " + weights.size()));
                    }
                }
                catch (DataSourceException e) {
                    throw new ObserveTechnicalException("Could not load weight measures", (Throwable)e);
                }
            }
            weightMeasuresTableModel.initCacheForRow(editingRow, weights);
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Using existing weights for row " + editingRow + ": " + weights.size()));
        }
        weightMeasuresTableModel.setData(weights);
        sizeMeasuresTableModel.setModified(false);
        weightMeasuresTableModel.setModified(false);
        if (!tableModel.isEditable()) {
            return;
        }
        if (tableModel.isCreate()) {
            ui.getFishingOperationTabPane().setSelectedIndex(0);
            ui.getAcquisitionModeGroup().setSelectedValue(null);
            ui.getAcquisitionModeGroup().setSelectedValue((Object)CatchAcquisitionModeEnum.INDIVIDUAL);
            ui.getPredator().setEnabled(false);
            ui.getHookWhenDiscarded().setEnabled(false);
            ui.getDiscardHealthness().setEnabled(false);
            ui.getBeatDiameter().setEnabled(false);
            requestFocus = ui.getSpeciesCatch();
        } else {
            int acquisitionMode = bean.getAcquisitionMode();
            CatchAcquisitionModeEnum enumValue = CatchAcquisitionModeEnum.valueOf(acquisitionMode);
            ui.getAcquisitionModeGroup().setSelectedValue(null);
            ui.getAcquisitionModeGroup().setSelectedValue((Object)enumValue);
            requestFocus = enumValue.equals((Object)CatchAcquisitionModeEnum.GROUPED) ? ui.getCount() : ui.getCatchHealthness();
        }
        bean.removePropertyChangeListener("catchFateLongline", this.catchFateChanged);
        bean.addPropertyChangeListener("catchFateLongline", this.catchFateChanged);
        bean.removePropertyChangeListener("depredated", this.depredatedChanged);
        bean.addPropertyChangeListener("depredated", this.depredatedChanged);
        LonglinePositionHelper positionHelper = (LonglinePositionHelper)this.POSITION_HELPER_ENTRY.getContextValue((JAXXContext)ui);
        positionHelper.resetPosition(bean);
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        List list;
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.catchlongline.table.speciesCatch", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.speciesCatch.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.acquisitionMode", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.acquisitionMode.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.count", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.count.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.catchHealthness", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.catchHealthness.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.catchFateLongline", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.catchFateLongline.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.discardHealthness", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.discardHealthness.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.depredated", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.depredated.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.comment", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.comment.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEnumTableCellRenderer((TableCellRenderer)renderer, CatchAcquisitionModeEnum.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Healthness.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, CatchFateLongline.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Healthness.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)6, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)7, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
        table = this.getUi().getSizeMeasuresTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.catchlongline.table.sizeMeasureType", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.sizeMeasureType.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.size", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.size.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, SizeMeasureType.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        Decorator decorator = ObserveContext.get().getDecorator(SizeMeasureType.class);
        try {
            list = this.getDataService().getList(this.getDataSource(), SizeMeasureType.class);
        }
        catch (DataSourceException e) {
            throw new ObserveTechnicalException("Could not get size measure types", (Throwable)e);
        }
        UIHelper.setTableColumnEditor((JTable)table, (int)0, (TableCellEditor)ContentUIInitializer.newDataColumnEditor(list, decorator));
        UIHelper.setTableColumnEditor((JTable)table, (int)1, (TableCellEditor)ContentUIInitializer.newFloatColumnEditor(table));
        EditableTableWithCacheTableModelSupport tableModel = this.getModel().getSizeMeasuresTableModel();
        tableModel.installTableKeyListener(this.getUi().getSizeMeasuresTable());
        tableModel.addPropertyChangeListener("modified", this.sizeTableModelModified);
        table = this.getUi().getWeightMeasuresTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.catchlongline.table.weightMeasureType", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.weightMeasureType.tip", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.weight", (Object[])new Object[0]), I18n.n((String)"observe.catchlongline.table.weight.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, WeightMeasureType.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        decorator = ObserveContext.get().getDecorator(WeightMeasureType.class);
        try {
            list = this.getDataService().getList(this.getDataSource(), WeightMeasureType.class);
        }
        catch (DataSourceException e) {
            throw new ObserveTechnicalException("Could not get size measure types", (Throwable)e);
        }
        UIHelper.setTableColumnEditor((JTable)table, (int)0, (TableCellEditor)ContentUIInitializer.newDataColumnEditor(list, decorator));
        UIHelper.setTableColumnEditor((JTable)table, (int)1, (TableCellEditor)ContentUIInitializer.newFloatColumnEditor(table));
        tableModel = this.getModel().getWeightMeasuresTableModel();
        tableModel.installTableKeyListener(this.getUi().getWeightMeasuresTable());
        tableModel.addPropertyChangeListener("modified", this.weightTableModelModified);
        this.getTableModel().addPropertyChangeListener("create", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean oldValue = (Boolean)evt.getOldValue();
                Boolean newValue = (Boolean)evt.getNewValue();
                CatchLonglineUIHandler.this.setTableModelCreate(oldValue, newValue);
            }
        });
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedSetId();
    }

    @Override
    public void initUI() throws Exception {
        ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
        String speciesListId = config.getSpeciesListLonglineCatch();
        this.prepareSpeciesList(speciesListId, (JComponent)this.getUi().getSpeciesCatch());
        speciesListId = config.getSpeciesListLonglineDepredator();
        this.prepareSpeciesList(speciesListId, (JComponent)this.getUi().getPredator());
        super.initUI();
        this.getModel().addPropertyChangeListener("showIndividualTabs", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newValue = (Boolean)evt.getNewValue();
                CatchLonglineUIHandler.this.showIndividualTabs(newValue);
            }
        });
        this.getModel().addPropertyChangeListener("editable", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newValue = (Boolean)evt.getNewValue();
                CatchLonglineUIHandler.this.setTableModelEditable(newValue);
            }
        });
        this.setTableModelEditable(this.getModel().isEditable());
        LonglinePositionHelper<LonglinePositionAware> positionHelper = new LonglinePositionHelper<LonglinePositionAware>(this.getUi().getSection(), this.getUi().getBasket(), this.getUi().getBranchline(), (LonglinePositionAware)this.getTableEditBean());
        this.POSITION_HELPER_ENTRY.setContextValue((JAXXContext)this.getUi(), positionHelper);
    }

    @Override
    protected SetLongline loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        SetLongline setLongline = (SetLongline)super.loadEditBean(mode, dataContext, dataService, dataSource);
        this.getModel().getSizeMeasuresTableModel().clear();
        this.getModel().getWeightMeasuresTableModel().clear();
        List sections = dataService.getSections(dataSource, setLongline.getTopiaId());
        LonglinePositionHelper positionHelper = (LonglinePositionHelper)this.POSITION_HELPER_ENTRY.getContextValue((JAXXContext)this.getUi());
        positionHelper.initSections(sections, this.getTableModel().getData());
        return setLongline;
    }

    @Override
    public void openUI() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("OpenUI: " + (Object)((Object)this.getModel())));
        }
        super.openUI();
        LonglinePositionHelper positionHelper = (LonglinePositionHelper)this.POSITION_HELPER_ENTRY.getContextValue((JAXXContext)this.getUi());
        this.getUi().getSection().setData(positionHelper.getSectionUniverse());
        this.getUi().getErrorTableModel().removeTableModelListener(this.computeTabValidStateListener);
        this.getUi().getErrorTableModel().addTableModelListener(this.computeTabValidStateListener);
        SwingValidatorMessageTableModel errorTableModel = this.getUi().getErrorTableModel();
        this.computeTabValidState(errorTableModel);
    }

    @Override
    protected void closeSafeUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("CloseUI: " + (Object)((Object)this.getModel())));
        }
        super.closeSafeUI();
        this.getUi().getErrorTableModel().removeTableModelListener(this.computeTabValidStateListener);
    }

    @Override
    protected void onUpdateFinalize(TopiaContext tx, SetLongline bean, Collection<CatchLongline> oldChilds) throws TopiaException {
        SizeMeasure measureToSave;
        ArrayList<SizeMeasure> measuresToSave;
        List measures;
        CatchLongline catchLongline;
        List catchLonglines = bean.getCatchLongline();
        LonglinePositionHelper positionHelper = (LonglinePositionHelper)this.POSITION_HELPER_ENTRY.getContextValue((JAXXContext)this.getUi());
        positionHelper.savePosition(catchLonglines);
        CatchLonglineUIModel model = this.getModel();
        SizeMeasureDAO measureDao = ObserveDAOHelper.getSizeMeasureDAO((TopiaContext)tx);
        SizeMeasuresTableModel sizeMeasuresTableModel = model.getSizeMeasuresTableModel();
        Set<Integer> rowsChanged = sizeMeasuresTableModel.getCacheRowsChanged();
        TopiaEntityBinder loader = sizeMeasuresTableModel.getLoader();
        for (Integer row : rowsChanged) {
            catchLongline = (CatchLongline)catchLonglines.get(row);
            measures = sizeMeasuresTableModel.getCacheForRow(row);
            measuresToSave = new ArrayList<SizeMeasure>(measures.size());
            for (SizeMeasure measure : measures) {
                if (!sizeMeasuresTableModel.isRowNotEmpty(measure)) continue;
                if (measure.getTopiaId() == null) {
                    measureToSave = (SizeMeasure)measureDao.create((TopiaEntity)measure);
                    loader.load((TopiaEntity)measureToSave, (TopiaEntity)measure, true, new String[0]);
                } else {
                    measureToSave = catchLongline.getSizeMeasureByTopiaId(measure.getTopiaId());
                    loader.load((TopiaEntity)measure, (TopiaEntity)measureToSave, true, new String[0]);
                }
                measuresToSave.add(measureToSave);
            }
            catchLongline.clearSizeMeasure();
            catchLongline.addAllSizeMeasure(measuresToSave);
        }
        WeightMeasureDAO dao = ObserveDAOHelper.getWeightMeasureDAO((TopiaContext)tx);
        WeightMeasuresTableModel weightMeasuresTableModel = model.getWeightMeasuresTableModel();
        TopiaEntityBinder loader2 = weightMeasuresTableModel.getLoader();
        Set<Integer> rowsChanged2 = weightMeasuresTableModel.getCacheRowsChanged();
        for (Integer row : rowsChanged2) {
            catchLongline = (CatchLongline)catchLonglines.get(row);
            measures = weightMeasuresTableModel.getCacheForRow(row);
            measuresToSave = new ArrayList(measures.size());
            for (SizeMeasure measure : measures) {
                if (weightMeasuresTableModel.isRowNotEmpty((WeightMeasure)measure)) {
                    if (measure.getTopiaId() == null) {
                        measureToSave = (WeightMeasure)dao.create((TopiaEntity)measure);
                        loader2.load((TopiaEntity)measureToSave, (TopiaEntity)measure, true, new String[0]);
                    } else {
                        measureToSave = catchLongline.getWeightMeasureByTopiaId(measure.getTopiaId());
                        loader2.load((TopiaEntity)measure, (TopiaEntity)measureToSave, true, new String[0]);
                    }
                    measuresToSave.add(measureToSave);
                }
                catchLongline.clearWeightMeasure();
                catchLongline.addAllWeightMeasure(measuresToSave);
            }
        }
    }

    @Override
    protected void resetEditBean() {
        UIHelper.stopEditing(this.getUi().getSizeMeasuresTable());
        UIHelper.stopEditing(this.getUi().getWeightMeasuresTable());
        super.resetEditBean();
    }

    public void updateCatchAcquisitionMode(CatchAcquisitionModeEnum newMode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Change CatchAcquisitionMode " + (Object)((Object)newMode)));
        }
        if (newMode == null) {
            return;
        }
        CatchLonglineUI ui = this.getUi();
        boolean createMode = ui.getTableModel().isCreate();
        CatchLongline editBean = ui.getTableEditBean();
        switch (newMode) {
            case GROUPED: {
                if (!createMode) break;
                editBean.setTotalWeight(null);
                editBean.setCount(null);
                editBean.setHookPosition(null);
                break;
            }
            case INDIVIDUAL: {
                if (!createMode) break;
                editBean.setCount(Integer.valueOf(1));
            }
        }
        boolean isGrouped = CatchAcquisitionModeEnum.GROUPED.equals((Object)newMode);
        ui.getTotalWeight().setEnabled(isGrouped);
        ui.getCount().setEnabled(isGrouped);
        boolean isIndividual = CatchAcquisitionModeEnum.INDIVIDUAL.equals((Object)newMode);
        ui.getHookPosition().setEnabled(isIndividual);
        ui.getSection().setEnabled(isIndividual);
        ui.getBasket().setEnabled(isIndividual);
        ui.getBranchline().setEnabled(isIndividual);
        if (createMode) {
            editBean.setAcquisitionMode(newMode.ordinal());
        }
        boolean showIndividualTabs = !createMode && isIndividual;
        ui.getModel().setShowIndividualTabs(showIndividualTabs);
    }

    protected void setTableModelEditable(Boolean newValue) {
        this.getModel().getSizeMeasuresTableModel().setEditable(newValue);
        this.getModel().getWeightMeasuresTableModel().setEditable(newValue);
    }

    protected void setTableModelCreate(Boolean oldValue, Boolean newValue) {
        if (BooleanUtils.isTrue((Boolean)oldValue) && BooleanUtils.isFalse((Boolean)newValue)) {
            CatchAcquisitionModeEnum acquisitionModeEnum = (CatchAcquisitionModeEnum)((Object)this.getUi().getAcquisitionModeGroup().getSelectedValue());
            this.getUi().getAcquisitionModeGroup().setSelectedValue(null);
            this.getUi().getAcquisitionModeGroup().setSelectedValue((Object)acquisitionModeEnum);
        }
    }

    protected void showIndividualTabs(boolean newValue) {
        if (log.isInfoEnabled()) {
            log.info((Object)("will show individuals tabs ?" + newValue));
        }
        this.getUi().getFoodAndSexualFormTab().setEnabled(newValue);
        this.getUi().getSizeMeasuresFormTab().setEnabled(newValue);
        this.getUi().getWeightMeasuresFormTab().setEnabled(newValue);
        if (!newValue && this.getUi().getFishingOperationTabPane().getSelectedIndex() > 2) {
            this.getUi().getFishingOperationTabPane().setSelectedIndex(0);
        }
    }

    protected void onCatchFateChanged(CatchFateLongline newValue, CatchLongline tableEditBean) {
        CatchLonglineUI ui = this.getUi();
        if (newValue == null || !"fr.ird.observe.entities.referentiel.longline.CatchFateLongline#1239832686125#0.3".equals(newValue.getTopiaId())) {
            ui.getDiscardHealthness().setEnabled(false);
            ui.getHookWhenDiscarded().setEnabled(false);
            ((CatchLongline)this.getTableEditBean()).setHookWhenDiscarded(null);
            ((CatchLongline)this.getTableEditBean()).setDiscardHealthness(null);
        } else {
            ui.getDiscardHealthness().setEnabled(true);
            ui.getHookWhenDiscarded().setEnabled(true);
        }
    }

    protected void onDepretadedChanged(Boolean newValue, CatchLongline tableEditBean) {
        CatchLonglineUI ui = this.getUi();
        if (BooleanUtils.isTrue((Boolean)newValue)) {
            ui.getBeatDiameter().setEnabled(true);
            ui.getPredator().setEnabled(true);
        } else {
            ui.getBeatDiameter().setEnabled(false);
            ui.getPredator().setEnabled(false);
            tableEditBean.setBeatDiameter(null);
            tableEditBean.setPredator(null);
        }
    }

    protected void onSizeTableModelModified(Boolean newValue) {
        if (newValue.booleanValue()) {
            this.getUi().getValidatorTable().setChanged(true);
        }
        this.getModel().getSizeMeasuresTableModel().validate();
    }

    protected void onWeightTableModelModified(Boolean newValue) {
        if (newValue.booleanValue()) {
            this.getUi().getValidatorTable().setChanged(true);
        }
        this.getModel().getWeightMeasuresTableModel().validate();
    }

    protected void computeTabValidState(SwingValidatorMessageTableModel errorTableModel) {
        HashSet<String> errorProperties = new HashSet<String>();
        int rowCount = errorTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            SwingValidatorMessage row = errorTableModel.getRow(i);
            if (!NuitonValidatorScope.ERROR.equals((Object)row.getScope())) continue;
            errorProperties.add(row.getField());
        }
        boolean caracteristicsTabValid = !errorProperties.removeAll(CatchLonglineUIModel.CARACTERISTIC_TAB_PROPERTIES);
        boolean depredatedTabValid = !errorProperties.removeAll(CatchLonglineUIModel.DEPREDATED_TAB_PROPERTIES);
        boolean foodAndSexualTabValid = !errorProperties.removeAll(CatchLonglineUIModel.FOOD_AND_SEXUAL_TAB_PROPERTIES);
        CatchLonglineUIModel model = this.getModel();
        model.setCaracteristicsTabValid(caracteristicsTabValid);
        model.setDepredatedTabValid(depredatedTabValid);
        model.setFoodAndSexualTabValid(foodAndSexualTabValid);
    }

    protected CatchLonglineTableModel getTableModel() {
        return (CatchLonglineTableModel)super.getTableModel();
    }
}

