/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.tree.AbstractObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.ObserveNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.painter.Painter;
import org.nuiton.i18n.I18n;

public class DataSelectionTreeCellRenderer
extends AbstractObserveTreeCellRenderer {
    private static final Log log = LogFactory.getLog(DataSelectionTreeCellRenderer.class);
    protected List<String> existingTripIds;

    public List<String> getExistingTripIds() {
        return this.existingTripIds;
    }

    public void setExistingTripIds(List<String> existingMareeIds) {
        this.existingTripIds = existingMareeIds;
    }

    @Override
    protected void init() {
        super.init();
        this.setBackgroundNonSelectionColor(null);
        this.setBackgroundSelectionColor(null);
        this.setBackground(null);
        this.setTextNonSelectionColor(Color.BLACK);
        this.setTextSelectionColor(Color.BLUE);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ObserveNode node = DataSelectionTreeCellRenderer.getNode(value);
        if (node == null) {
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
        this.setIcon(node);
        String text = this.getNodeText((NavNode)node);
        if (log.isDebugEnabled()) {
            text = text + " (" + row + ')';
            log.debug((Object)("repaint node " + text + " (selected:" + sel + ") for node  " + node.getId()));
        }
        boolean exist = false;
        if (TripSeine.class.equals((Object)node.getInternalClass()) && this.existingTripIds != null && this.existingTripIds.contains(node.getId())) {
            text = I18n.t((String)"observe.comon.exist.on.remote", (Object[])new Object[]{text});
            exist = true;
        }
        Component comp = super.getTreeCellRendererComponent(tree, (Object)text, sel, expanded, leaf, row, hasFocus);
        if (exist) {
            text = I18n.t((String)"observe.message.warning.will.be.delete", (Object[])new Object[]{text});
        }
        ((JComponent)comp).setToolTipText(text);
        return comp;
    }

    public static void initUI(JScrollPane selectedTreePane, JTree tree) {
        UIDefaults defaults = new UIDefaults();
        Painter<JComponent> painter = new Painter<JComponent>(){

            public void paint(Graphics2D g, JComponent c, int w, int h) {
                g.fillRect(0, 0, w, h);
            }
        };
        defaults.put("Tree:TreeCell[Enabled+Selected].backgroundPainter", painter);
        defaults.put("Tree:TreeCell[Enabled+Focused].backgroundPainter", painter);
        defaults.put("Tree:TreeCell[Focused+Selected].backgroundPainter", painter);
        tree.putClientProperty("Nimbus.Overrides", defaults);
        selectedTreePane.getViewport().setBackground(Color.WHITE);
    }
}

