/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.constants.ReferenceStatus;
import fr.ird.observe.entities.referentiel.ReferenceEntities;
import fr.ird.observe.entities.referentiel.ReferenceEntity;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.actions.AbstractUIAction;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.util.BooleanEditor;
import fr.ird.observe.util.DBHelper;
import fr.ird.observe.validation.ObserveValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.bean.JavaBeanObjectUtil;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditor;
import org.nuiton.jaxx.widgets.datetime.TimeEditor;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;
import org.nuiton.jaxx.widgets.select.FilterableDoubleList;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.util.DateUtil;

public class ContentUIInitializer<E extends TopiaEntity, UI extends ObserveContentUI<E>> {
    public static final String OBSERVE_ACTION = "observeAction";
    public static final String CLIENT_PROPERTY_PROPERTY_NAME = "propertyName";
    public static final String CLIENT_PROPERTY_RESET_PROPERTY_NAME = "resetPropertyName";
    public static final String CLIENT_PROPERTY_NOT_BLOCKING = "notBlocking";
    private static final Log log = LogFactory.getLog(ContentUIInitializer.class);
    protected final UI ui;

    public ContentUIInitializer(UI ui) {
        this.ui = ui;
    }

    protected static void attachTopiaContext(DataSource service, TopiaEntityAbstract entity) {
        DBHelper.attachTopiaContext((TopiaContext)service.getRootCtxt(), (TopiaEntityAbstract)entity);
    }

    protected E getBean() {
        Object bean = this.ui.getModel().getBean();
        return bean;
    }

    public void initUI(DataSource dataSource) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ui " + this.getClass()));
        }
        ActionMap actionMap = ObserveContext.get().getActionMap();
        this.init(dataSource);
        HashSet<String> doNotBlockComponentIds = new HashSet<String>();
        DecoratorService decoratorService = ObserveContext.get().getDecoratorService();
        for (String name : this.ui.get$objectMap().keySet()) {
            Object o = this.ui.getObjectById(name);
            if (o == null) continue;
            if (o instanceof TopiaEntityAbstract) {
                this.init(dataSource, (TopiaEntityAbstract)o);
                continue;
            }
            if (o instanceof JComponent) {
                this.init((JComponent)o, doNotBlockComponentIds);
            }
            if (o instanceof JCheckBox) {
                this.init((JCheckBox)o);
            }
            if (o instanceof AbstractButton) {
                this.init(actionMap, (AbstractButton)o);
                continue;
            }
            if (o instanceof NumberEditor) {
                this.init((NumberEditor)o);
                continue;
            }
            if (o instanceof BeanComboBox) {
                this.init(dataSource, (BeanComboBox)o);
                continue;
            }
            if (o instanceof BeanListHeader) {
                this.init(dataSource, decoratorService, (BeanListHeader)o);
                continue;
            }
            if (o instanceof FilterableDoubleList) {
                this.init(dataSource, (FilterableDoubleList)o);
                continue;
            }
            if (o instanceof JXDatePicker) {
                this.init((JXDatePicker)o);
                continue;
            }
            if (o instanceof TimeEditor) {
                this.init((TimeEditor)o);
                continue;
            }
            if (o instanceof DateTimeEditor) {
                this.init((DateTimeEditor)o);
                continue;
            }
            if (o instanceof CoordinatesEditor) {
                this.init((CoordinatesEditor)o);
                continue;
            }
            if (o instanceof BooleanEditor) {
                this.init((BooleanEditor)o);
                continue;
            }
            if (o instanceof ObserveValidator) {
                this.init(this.ui, (ObserveValidator)o);
                continue;
            }
            if (o instanceof JTextField) {
                this.init((JTextField)o);
                continue;
            }
            if (!(o instanceof JTextArea)) continue;
            this.init((JTextArea)o);
        }
        if (!doNotBlockComponentIds.isEmpty()) {
            String[] acceptedComponentNames = doNotBlockComponentIds.toArray(new String[doNotBlockComponentIds.size()]);
            this.initBlockLayerUI(acceptedComponentNames);
        }
    }

    protected void initBlockLayerUI(String ... doNotBlockComponentIds) {
        this.ui.getBlockLayerUI().setAcceptedComponentNames(doNotBlockComponentIds);
    }

    protected void init(UI ui, ObserveValidator<?> validator) {
        SwingValidatorUtil.listenValidatorContextNameAndRefreshFields(validator, (JAXXValidator)((JAXXValidator)ui));
    }

    protected void init(DataSource service) throws DataSourceException {
        this.init(service, (TopiaEntityAbstract)this.getBean());
    }

    protected void init(DataSource service, TopiaEntityAbstract bean) throws DataSourceException {
        if (bean == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init entity " + bean.getClass()));
        }
        ContentUIInitializer.attachTopiaContext(service, bean);
    }

    protected void init(ActionMap actionMap, AbstractButton editor) throws DataSourceException {
        String actionId = (String)editor.getClientProperty(OBSERVE_ACTION);
        if (actionId == null) {
            final String propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_RESET_PROPERTY_NAME);
            if (propertyName != null) {
                editor.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, null);
                    }
                });
            }
            return;
        }
        AbstractUIAction action = (AbstractUIAction)actionMap.get(actionId);
        if (action == null) {
            throw new IllegalStateException("action [" + actionId + "] not found for ui " + this.ui.getClass().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init common action " + actionId));
        }
        action.initAction(null, editor);
    }

    protected void init(NumberEditor editor) throws DataSourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init number editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(DataSource dataSource, BeanComboBox beanComboBox) throws DataSourceException {
        Class klass = beanComboBox.getHandler().getBeanType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("init combobox for " + klass));
        }
        beanComboBox.setI18nPrefix("observe.common.");
        beanComboBox.setMinimumSize(new Dimension(0, 24));
        this.prepareBeanComboBox(dataSource, klass, beanComboBox);
    }

    protected void init(DataSource dataSource, DecoratorService decoratorService, BeanListHeader beanList) throws DataSourceException {
        beanList.setI18nPrefix("observe.common.");
        if (log.isInfoEnabled()) {
            log.info((Object)("init list for " + beanList.getBeanType()));
        }
        this.prepareEntityList(dataSource, beanList.getBeanType(), beanList);
        JList jlist = beanList.getList();
        Object init = jlist.getClientProperty("addDecorator");
        if (init != null) {
            Class klass = (Class)init;
            if (log.isDebugEnabled()) {
                log.debug((Object)("addDecorator to list " + jlist.getName()));
            }
            Decorator decorator = decoratorService.getDecoratorByType(klass);
            jlist.putClientProperty("decorator", decorator);
        }
        if ((init = jlist.getClientProperty("addToogleListSelectionModel")) != null && init instanceof Boolean && ((Boolean)init).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addToogleListSelectionModel to list " + jlist.getName()));
            }
            this.prepareToogleListSelectionModel(jlist);
        }
    }

    protected void init(DataSource dataSource, FilterableDoubleList beanList) throws DataSourceException {
        beanList.setI18nPrefix("observe.common.");
        if (log.isInfoEnabled()) {
            log.info((Object)("init list for " + beanList.getBeanType()));
        }
        this.prepareEntityList(dataSource, beanList.getBeanType(), beanList);
    }

    protected void init(TimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init time editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(DateTimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init date time editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(CoordinatesEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init coordinates editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(JTextField editor) {
        final String propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_PROPERTY_NAME);
        if (propertyName != null) {
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    JTextField source = (JTextField)e.getSource();
                    String text = source.getText();
                    JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, (Object)text);
                }
            });
        }
    }

    protected void init(JTextArea editor) {
        final String propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_PROPERTY_NAME);
        if (propertyName != null) {
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    JTextArea source = (JTextArea)e.getSource();
                    String text = source.getText();
                    JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, (Object)text);
                }
            });
        }
    }

    protected void init(BooleanEditor editor) throws DataSourceException {
        String propertyName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("init boolean editor " + editor.getName()));
        }
        if ((propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_PROPERTY_NAME)) != null) {
            editor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        Boolean newValue = ((BooleanEditor)event.getSource()).getBooleanValue();
                        JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, (Object)newValue);
                    }
                }
            });
        }
    }

    protected void init(JComponent editor, Set<String> notBlockingComponents) throws DataSourceException {
        Boolean propertyName = (Boolean)editor.getClientProperty(CLIENT_PROPERTY_NOT_BLOCKING);
        if (propertyName != null) {
            notBlockingComponents.add(editor.getName());
        }
    }

    protected void init(JCheckBox editor) throws DataSourceException {
        String propertyName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("init simple boolean editor " + editor.getName()));
        }
        if ((propertyName = (String)editor.getClientProperty(CLIENT_PROPERTY_PROPERTY_NAME)) != null) {
            editor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    Boolean newValue = ((JCheckBox)event.getSource()).isSelected();
                    JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, (Object)newValue);
                }
            });
        }
    }

    protected void init(JXDatePicker picker) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("disable JXDatePicker editor" + picker.getName()));
        }
        picker.getEditor().setEditable(false);
        JXMonthView monthView = new JXMonthView();
        monthView.setLowerBound(DateUtil.createDate((int)1, (int)1, (int)1970));
        monthView.setTraversable(true);
        monthView.setZoomable(true);
        picker.setMonthView(monthView);
        final String propertyName = (String)picker.getClientProperty((Object)CLIENT_PROPERTY_PROPERTY_NAME);
        if (propertyName != null) {
            picker.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JXDatePicker source = (JXDatePicker)e.getSource();
                    Date date = source.getDate();
                    JavaBeanObjectUtil.setProperty(ContentUIInitializer.this.getBean(), (String)propertyName, (Object)date);
                }
            });
        }
    }

    protected void prepareToogleListSelectionModel(JList list) {
        OneClicListSelectionModel model = new OneClicListSelectionModel(list.getSelectionModel(), list.getModel());
        list.setSelectionModel((ListSelectionModel)model);
    }

    protected <E extends TopiaEntity> void prepareEntityList(DataSource storageService, Class<E> entityClass, FilterableDoubleList<E> list) throws DataSourceException {
        List data;
        ObserveContext tx = ObserveContext.get();
        Decorator decorator = tx.getDecorator(entityClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use decorator " + decorator));
        }
        list.putClientProperty((Object)"decorator", (Object)decorator);
        if (ReferenceEntity.class.isAssignableFrom(entityClass)) {
            Predicate predicate = (Predicate)list.getClientProperty((Object)"listPredicate");
            data = tx.getDataService().getList(storageService, entityClass, predicate);
        } else {
            data = new ArrayList();
        }
        DecoratorUtil.sort((JXPathDecorator)((JXPathDecorator)decorator), data, (int)0);
        list.init((JXPathDecorator)decorator, data, Collections.emptyList());
        ListCellRenderer renderer = list.getSelectedList().getCellRenderer();
        list.getSelectedList().setCellRenderer(new ReferentielListCellRenderer(renderer));
        list.getUniverseList().setCellRenderer(new ReferentielListCellRenderer(renderer));
        list.putClientProperty((Object)"data", data);
        EntityDoubleListPropertyChangeListener<E> listener = new EntityDoubleListPropertyChangeListener<E>(entityClass, list);
        DataService service = ObserveContext.get().getDataService();
        service.addReferentielPropertyChangeListener(entityClass, listener);
    }

    protected <E extends TopiaEntity> void prepareEntityList(DataSource storageService, Class<E> entityClass, BeanListHeader<E> list) throws DataSourceException {
        List data;
        ObserveContext tx = ObserveContext.get();
        Decorator decorator = tx.getDecorator(entityClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use decorator " + decorator));
        }
        list.putClientProperty((Object)"decorator", (Object)decorator);
        if (ReferenceEntity.class.isAssignableFrom(entityClass)) {
            Predicate predicate = (Predicate)list.getClientProperty((Object)"listPredicate");
            data = tx.getDataService().getList(storageService, entityClass, predicate);
        } else {
            data = new ArrayList();
        }
        DecoratorUtil.sort((JXPathDecorator)((JXPathDecorator)decorator), data, (int)0);
        list.init((JXPathDecorator)decorator, data);
        ListCellRenderer renderer = list.getList().getCellRenderer();
        list.getList().setCellRenderer(new ReferentielListCellRenderer(renderer));
        list.putClientProperty((Object)"data", data);
        EntityListPropertyChangeListener<E> listener = new EntityListPropertyChangeListener<E>(entityClass, list);
        DataService service = ObserveContext.get().getDataService();
        service.addReferentielPropertyChangeListener(entityClass, listener);
    }

    protected <E extends TopiaEntity> void prepareBeanComboBox(DataSource storageService, Class<E> entityClass, BeanComboBox<E> comboBox) throws DataSourceException {
        List data;
        ObserveContext context = ObserveContext.get();
        Decorator decorator = context.getDecorator(entityClass);
        DataService service = context.getDataService();
        Boolean noLoad = (Boolean)comboBox.getClientProperty((Object)"listNoLoad");
        if (noLoad != null && noLoad.booleanValue()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Skip loading of entity list [" + entityClass.getName() + "] (listNoLoad property found)"));
            }
            data = Collections.emptyList();
        } else {
            Predicate predicate = (Predicate)comboBox.getClientProperty((Object)"listPredicate");
            data = service.getList(storageService, entityClass, predicate);
        }
        boolean referenceEntity = ReferenceEntity.class.isAssignableFrom(entityClass);
        if (referenceEntity) {
            ReferenceEntities.filterReferentielListByStatus((List)data);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("entity list [" + entityClass.getName() + "] : " + data.size()));
        }
        comboBox.init((JXPathDecorator)decorator, data);
        final ListCellRenderer renderer = comboBox.getCombobox().getRenderer();
        ListCellRenderer toolTipRenderer = new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (comp instanceof JLabel) {
                    JLabel jcomp = (JLabel)comp;
                    jcomp.setToolTipText(jcomp.getText());
                }
                return comp;
            }
        };
        comboBox.getCombobox().setRenderer(toolTipRenderer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("combo  list [" + entityClass.getName() + "] : " + comboBox.getData().size()));
        }
        if (referenceEntity) {
            BeanComboBoxPropertyChangeListener listener = new BeanComboBoxPropertyChangeListener(entityClass, comboBox){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("entity list [" + evt.getPropertyName() + "]"));
                    }
                    super.propertyChange(evt);
                }
            };
            service.addReferentielPropertyChangeListener(entityClass, (PropertyChangeListener)listener);
        }
    }

    public static TableCellEditor newFloatColumnEditor(JTable table) {
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Float.class, (boolean)false);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern("\\d{0,6}(\\.\\d{0,4})?");
        return editor;
    }

    public static TableCellEditor newIntegerColumnEditor(JTable table) {
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Integer.class, (boolean)false);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern("\\d{0,4}?");
        return editor;
    }

    public static <B> ComboBoxCellEditor newDataColumnEditor(List<B> data, Decorator<B> decorator) {
        JComboBox comboBox = new JComboBox();
        return ContentUIInitializer.newDataColumnEditor(comboBox, data, decorator);
    }

    public static <B> ComboBoxCellEditor newDataColumnEditor(JComboBox comboBox, List<B> data, Decorator<B> decorator) {
        DecoratorListCellRenderer renderer = new DecoratorListCellRenderer(decorator);
        comboBox.setRenderer(renderer);
        ContentUIInitializer.prepareComboBoxData(comboBox, data);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate((JComboBox)comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        return editor;
    }

    public static <B> void prepareComboBoxData(JComboBox comboBox, List<B> data) {
        ArrayList dataToList = Lists.newArrayList(data);
        if (!dataToList.isEmpty() && dataToList.get(0) != null) {
            dataToList.add(0, null);
        }
        SwingUtil.fillComboBox((JComboBox)comboBox, (Collection)dataToList, null);
    }

    protected static class BeanComboBoxPropertyChangeListener<E extends ReferenceEntity>
    implements PropertyChangeListener {
        private final Class<E> entityClass;
        private final BeanComboBox<E> comboBox;

        public BeanComboBoxPropertyChangeListener(Class<E> entityClass, BeanComboBox<E> comboBox) {
            this.entityClass = entityClass;
            this.comboBox = comboBox;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ArrayList newValue = new ArrayList((List)evt.getNewValue());
            if (log.isDebugEnabled()) {
                log.debug((Object)("reloading entities list for [" + this.entityClass + "], size : " + newValue.size()));
            }
            ReferenceEntities.filterReferentielListByStatus(newValue);
            ReferenceEntity selectedItem = (ReferenceEntity)this.comboBox.getSelectedItem();
            this.comboBox.setData(newValue);
            if (selectedItem != null) {
                ReferenceEntity newSelectedItem = UIHelper.getEntity(newValue, selectedItem);
                this.comboBox.setSelectedItem(null);
                if (newSelectedItem != null) {
                    this.comboBox.setSelectedItem((Object)newSelectedItem);
                }
            }
        }
    }

    public static class ReferentielListCellRenderer
    implements ListCellRenderer {
        protected Color normalColor;
        protected Color disableColor = Color.LIGHT_GRAY;
        protected ListCellRenderer delegate;

        public ReferentielListCellRenderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent comp = (JComponent)this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (this.normalColor == null) {
                this.normalColor = comp.getForeground();
            }
            String tip = ((JLabel)comp).getText();
            Color col = this.normalColor;
            if (value != null && value instanceof ReferenceEntity) {
                ReferenceEntity e = (ReferenceEntity)value;
                ReferenceStatus status = e.getStatus();
                if (status == ReferenceStatus.disabled) {
                    col = this.disableColor;
                    tip = I18n.t((String)"observe.common.obsolete.entity", (Object[])new Object[]{tip});
                } else {
                    tip = null;
                }
            } else {
                tip = null;
            }
            comp.setForeground(col);
            comp.setToolTipText(tip);
            return comp;
        }
    }

    protected static class EntityDoubleListPropertyChangeListener<E extends TopiaEntity>
    implements PropertyChangeListener {
        private Class<E> entityClass;
        private FilterableDoubleList<E> list;

        public EntityDoubleListPropertyChangeListener(Class<E> entityClass, FilterableDoubleList<E> list) {
            this.entityClass = entityClass;
            this.list = list;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List newValue = (List)evt.getNewValue();
            Decorator decorator = (Decorator)this.list.getClientProperty((Object)"decorator");
            if (log.isDebugEnabled()) {
                log.debug((Object)("reloading entities list for [" + this.entityClass + "], size : " + newValue.size()));
            }
            DecoratorUtil.sort((JXPathDecorator)((JXPathDecorator)decorator), (List)newValue, (int)0);
            this.list.putClientProperty((Object)"data", (Object)newValue);
            ArrayList selectedValues = new ArrayList(this.list.getModel().getSelected());
            this.list.setUniverse(Collections.emptyList());
            this.list.setUniverse((Collection)newValue);
            selectedValues.retainAll(newValue);
            this.list.setSelected(selectedValues);
        }
    }

    protected static class EntityListPropertyChangeListener<E extends TopiaEntity>
    implements PropertyChangeListener {
        private Class<E> entityClass;
        private BeanListHeader<E> list;

        public EntityListPropertyChangeListener(Class<E> entityClass, BeanListHeader<E> list) {
            this.entityClass = entityClass;
            this.list = list;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List newValue = (List)evt.getNewValue();
            Decorator decorator = (Decorator)this.list.getClientProperty((Object)"decorator");
            if (log.isDebugEnabled()) {
                log.debug((Object)("reloading entities list for [" + this.entityClass + "], size : " + newValue.size()));
            }
            DecoratorUtil.sort((JXPathDecorator)((JXPathDecorator)decorator), (List)newValue, (int)0);
            TopiaEntity selectedValue = (TopiaEntity)this.list.getSelectedValue();
            this.list.putClientProperty((Object)"data", (Object)newValue);
            this.list.setData(Collections.emptyList());
            this.list.setData(newValue);
            if (selectedValue != null && newValue.contains(selectedValue)) {
                this.list.getList().setSelectedValue(selectedValue, true);
            }
        }
    }
}

