/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.ObjetFlottantDAO;
import fr.ird.observe.entities.referentiel.OperationObjet;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.impl.ObjetFlottantUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderModelBuilder;

public class ObjetFlottantUIHandler
extends ContentUIHandler<ObjetFlottant> {
    private static Log log = LogFactory.getLog(ObjetFlottantUIHandler.class);

    public ObjetFlottantUIHandler(ObjetFlottantUI ui) {
        super(ui, DataContextType.Activite, DataContextType.ObjetFlottant);
    }

    public ObjetFlottantUI getUi() {
        return (ObjetFlottantUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<ObjetFlottant> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(this.getBeanType(), binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(ObjetFlottant.class, new String[]{"type", "devenir", "operation", "appartenance", "commentaire", "nomSupply", "nbJourEau"});
            r = binderService.registerTopiaBinder(this.getBeanType(), builder, binderName);
        }
        return r;
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String dcpId = this.getSelectedId();
        if (dcpId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Activite.class)) {
            return ContentMode.UPDATE;
        }
        ObjetFlottantUIHandler.addMessage(this.getUi(), BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.activite.not.open"));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activiteId = this.getSelectedParentId();
        String dcpId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activiteId = " + activiteId));
            log.info((Object)("dcpId      = " + dcpId));
        }
        ContentMode mode = this.computeContentMode();
        ObjetFlottant bean = (ObjetFlottant)this.getBean();
        DataService dataService = this.getDataService();
        if (dcpId == null) {
            dataService.preCreate(this.getDataSource(), activiteId, (TopiaEntity)bean, this.getLoadBinder(), this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(this.getDataSource(), dcpId, this.getLoadExecutor());
        }
        this.setContentMode(mode);
        if (mode != ContentMode.READ) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        ContentUIModel contentUIModel = this.getModel();
        boolean create = contentUIModel.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(contentUIModel.getMode());
        this.getUi().getValidator().setContextName(contextName);
        if (create) {
            ObjetFlottantUIHandler.addMessage(this.getUi(), BeanValidatorScope.INFO, this.getEntityLabel(ObjetFlottant.class), I18n._((String)"observe.message.creating.objetFlottant"));
        } else {
            ObjetFlottantUIHandler.addMessage(this.getUi(), BeanValidatorScope.INFO, this.getEntityLabel(ObjetFlottant.class), I18n._((String)"observe.message.updating.objetFlottant"));
        }
        super.startEditUI("nbJourEau.model", "type.selectedItem", "devenir.selectedItem", "nomSupply.text", "commentaire2.text", "appartenance.selectedIndex");
        contentUIModel.setModified(create);
    }

    @Override
    protected boolean doSave(ObjetFlottant bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<ObjetFlottant> binder) throws Exception {
        String activiteId = this.getSelectedParentId();
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, activiteId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        return true;
    }

    @Override
    protected ObjetFlottant onCreate(TopiaContext tx, Object parent, ObjetFlottant editBean) throws TopiaException {
        Activite parentBean = (Activite)parent;
        ObjetFlottantDAO dao = ObserveDAOHelper.getObjetFlottantDAO((TopiaContext)tx);
        ObjetFlottant beanToSave = (ObjetFlottant)dao.create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addObjetFlottant(beanToSave);
        return beanToSave;
    }

    @Override
    protected ObjetFlottant onUpdate(TopiaContext tx, Object parentBean, ObjetFlottant beanToSave) throws TopiaException {
        this.getLoadBinder().copy(this.getBean(), (Object)beanToSave, new String[0]);
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        boolean create;
        super.afterSave(refresh);
        ObjetFlottant bean = (ObjetFlottant)this.getBean();
        ObserveTreeHelper treeHelper = ObjetFlottantUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        boolean bl = create = node.getId() == null;
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
            node = treeHelper.addObjetFlottant(parentNode, bean);
            this.stopEditUI();
            if (refresh) {
                treeHelper.selectNode((NavNode)node);
            }
        } else {
            treeHelper.refreshNode((NavNode)node, false);
        }
    }

    @Override
    protected boolean doDelete(ObjetFlottant bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, ObjetFlottant> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        if (bean.getTopiaId() != null) {
            String activiteId = this.getSelectedParentId();
            dataService.delete(dataSource, activiteId, (TopiaEntity)bean, deletor);
        }
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, ObjetFlottant beanToDelete) {
        Activite parentBean = (Activite)parent;
        parentBean.removeObjetFlottant(beanToDelete);
    }

    public void selectOperations(ObjetFlottant bean, Object[] selected) {
        boolean update;
        boolean bl = update = selected.length != bean.sizeOperation();
        if (!update && selected.length > 0) {
            Collection list = bean.getOperation();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = this.getUi().getOperation().getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            ArrayList<OperationObjet> newList = new ArrayList<OperationObjet>(selected.length);
            for (Object o : selected) {
                newList.add((OperationObjet)o);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("update operations " + newList.size()));
            }
            bean.setOperation(newList);
            selectionModel.setValueIsAdjusting(false);
        }
    }
}

