/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.simpleapi.IAction;
import org.eclipse.birt.report.model.simpleapi.Structure;

public class ActionImpl
extends Structure
implements IAction {
    private DesignElementHandle handle;
    private Action action;

    public ActionImpl(ActionHandle acHandle, ReportItemHandle handle) {
        super(acHandle);
        if (acHandle != null) {
            this.handle = handle;
            this.action = (Action)acHandle.getStructure();
        } else {
            this.action = new Action();
        }
    }

    public ActionImpl() {
        super(null);
        this.action = new Action();
    }

    @Override
    public String getURI() {
        return this.action.getStringProperty(null, "uri");
    }

    @Override
    public String getTargetWindow() {
        return this.action.getStringProperty(null, "targetWindow");
    }

    @Override
    public String getLinkType() {
        return this.action.getStringProperty(null, "linkType");
    }

    @Override
    public void setLinkType(String type) throws SemanticException {
        ActivityStack cmdStack = null;
        if (this.structureHandle != null) {
            cmdStack = this.structureHandle.getModule().getActivityStack();
        } else if (this.handle != null) {
            this.checkAction();
            cmdStack = this.handle.getModule().getActivityStack();
        }
        if (cmdStack != null) {
            cmdStack.startNonUndoableTrans(null);
            try {
                this.action.setProperty("linkType", (Object)type);
            }
            catch (Exception exception) {
                cmdStack.rollback();
                throw new SemanticException(this.handle.getElement(), "Failed to set action Link type  value");
            }
            cmdStack.commit();
        } else {
            this.action.setProperty("linkType", (Object)type);
        }
    }

    @Override
    public void setFormatType(String type) throws SemanticException {
        this.setActionProperty("formatType", type);
    }

    @Override
    public String getFormatType() {
        return this.action.getStringProperty(null, "formatType");
    }

    @Override
    public void setTargetWindow(String window) throws SemanticException {
        this.setActionProperty("targetWindow", window);
    }

    @Override
    public void setURI(String uri) throws SemanticException {
        this.setActionProperty("uri", uri);
    }

    @Override
    public String getReportName() {
        return this.action.getStringProperty(null, "reportName");
    }

    @Override
    public void setReportName(String reportName) throws SemanticException {
        this.setActionProperty("reportName", reportName);
    }

    @Override
    public String getTargetBookmark() {
        return this.action.getStringProperty(null, "targetBookmark");
    }

    @Override
    public void setTargetBookmark(String bookmark) throws SemanticException {
        this.setActionProperty("targetBookmark", bookmark);
    }

    private void checkAction() throws SemanticException {
        if (this.handle != null) {
            if (this.handle instanceof LabelHandle) {
                ((LabelHandle)this.handle).setAction(this.action);
                this.structureHandle = ((LabelHandle)this.handle).getActionHandle();
            } else if (this.handle instanceof ImageHandle) {
                ((ImageHandle)this.handle).setAction(this.action);
                this.structureHandle = ((ImageHandle)this.handle).getActionHandle();
            } else if (this.handle instanceof DataItemHandle) {
                ((DataItemHandle)this.handle).setAction(this.action);
                this.structureHandle = ((DataItemHandle)this.handle).getActionHandle();
            } else {
                throw new PropertyNameException(this.handle.getElement(), "action");
            }
        }
    }

    private void setActionProperty(String propName, String value) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty(propName, value);
        } else {
            this.checkAction();
            this.action.setProperty(propName, (Object)value);
        }
    }

    @Override
    public IStructure getStructure() {
        return this.action;
    }
}

