/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer.feed.record;

import fr.ifremer.tutti.ichtyometer.feed.record.FeedReaderMeasureRecord;
import fr.ifremer.tutti.ichtyometer.feed.record.FeedReaderRecordSupport;
import fr.ifremer.tutti.ichtyometer.feed.record.FeedReaderStylusMotionRecord;
import java.util.LinkedHashSet;
import java.util.Set;

public class FeedReaderRecordFactory {
    protected final Set<FeedReaderRecordAceptor> acceptors = new LinkedHashSet<FeedReaderRecordAceptor>();

    public FeedReaderRecordFactory() {
        this.acceptors.add(new FeedReaderRecordAceptor<FeedReaderStylusMotionRecord>(){

            @Override
            public boolean accept(String record) {
                return FeedReaderStylusMotionRecord.acceptRecord(record);
            }

            @Override
            public FeedReaderStylusMotionRecord newRecord(String record) {
                return new FeedReaderStylusMotionRecord(record);
            }
        });
        this.acceptors.add(new FeedReaderRecordAceptor<FeedReaderMeasureRecord>(){

            @Override
            public boolean accept(String record) {
                return FeedReaderMeasureRecord.acceptRecord(record);
            }

            @Override
            public FeedReaderMeasureRecord newRecord(String record) {
                return new FeedReaderMeasureRecord(record);
            }
        });
    }

    public FeedReaderRecordSupport newRecord(String record) {
        FeedReaderRecordSupport feedRecord = null;
        for (FeedReaderRecordAceptor acceptor : this.acceptors) {
            boolean accept = acceptor.accept(record);
            if (!accept) continue;
            feedRecord = (FeedReaderRecordSupport)acceptor.newRecord(record);
            break;
        }
        return feedRecord;
    }

    protected static interface FeedReaderRecordAceptor<F extends FeedReaderRecordSupport> {
        public boolean accept(String var1);

        public F newRecord(String var1);
    }
}

