
package fr.ifremer.suiviobsmer.ui.data;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.ContactFilter;
import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.services.ServiceContact;
import java.util.Map;
import org.apache.tapestry5.grid.SortConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ContactDataSource
 *
 * Created: 18 janv. 2010
 *
 * @author fdesbois
 * @version $Revision: 238 $
 *
 * Mise a jour: $Date: 2010-01-19 15:57:51 +0100 (mar., 19 janv. 2010) $
 * par : $Author$
 */
public class ContactDataSource extends AbstractMappedGridDataSource<String, Contact> {

    private static Logger log = LoggerFactory.getLogger(ContactDataSource.class);

    private ContactFilter filter;

    private ServiceContact serviceContact;

    public ContactDataSource(ContactFilter filter, ServiceContact service) {
        this.filter = filter;
        serviceContact = service;
    }

    @Override
    public Class<?> getRowType() {
        return Contact.class;
    }
    
    @Override
    protected Map<String, Contact> execute(int startIndex, int endIndex, SortConstraint orderBy) throws SuiviObsmerException {
        if (log.isInfoEnabled()) {
            log.info("BUSINESS REQUEST [getContactsByFilter]");
        }
        filter.setStartIndex(startIndex);
        filter.setEndIndex(endIndex);
        return serviceContact.getContactsByFilter(filter);
    }

    @Override
    protected int count() throws SuiviObsmerException {
        if (log.isInfoEnabled()) {
            log.info("BUSINESS REQUEST [countContactsByFilter]");
        }
        return serviceContact.countContactsByFilter(filter);
    }

}
