/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.types.hibernate.MatrixDatabaseHelper;
import fr.ifremer.isisfish.ui.SaveVerifier;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputUI;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public class InputSaveVerifier
implements SaveVerifier {
    private static Log log = LogFactory.getLog(InputSaveVerifier.class);
    protected boolean changed = false;
    protected InputContentUI<?> inputContentUI;
    protected HashMap<String, TopiaEntityContextable> currentEntities = new HashMap();
    protected PropertyChangeListener entityPCL = evt -> {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PropertyChanged : " + evt.getPropertyName() + " New Value : " + String.valueOf(evt.getNewValue())));
        }
        this.topiaChanged();
    };

    public InputContentUI<?> getInputContentUI() {
        return this.inputContentUI;
    }

    public void setInputContentUI(InputContentUI<?> inputContentUI) {
        this.inputContentUI = inputContentUI;
    }

    @Override
    public int checkEdit() {
        int response = 1;
        if (this.changed) {
            response = JOptionPane.showConfirmDialog(this.inputContentUI, I18n.t((String)"isisfish.message.page.modified", (Object[])new Object[0]), I18n.t((String)"isisfish.input.menu.commit", (Object[])new Object[0]), 1, 2);
            if (response == 1) {
                this.cancel();
            } else if (response == 0) {
                this.save();
            }
        }
        return response;
    }

    protected void topiaChanged() {
        this.changed = true;
    }

    protected void noModif() {
        this.changed = false;
    }

    public void delete() {
        try {
            Object topiaEntity = this.inputContentUI.getBean();
            List<TopiaEntity> referencedEntitites = MatrixDatabaseHelper.checkUsedObjects(topiaEntity.getTopiaContext(), topiaEntity);
            if (referencedEntitites.isEmpty()) {
                boolean doDelete;
                List allWillBeRemoved = topiaEntity.getComposite();
                if (!allWillBeRemoved.isEmpty()) {
                    String text;
                    String label = I18n.t((String)"isisfish.message.delete.object", (Object[])new Object[]{this.toString((TopiaEntity)topiaEntity)});
                    int resp = this.showTextAreaConfirmationMessage(null, label, text = allWillBeRemoved.stream().map(e -> ClassUtils.getShortClassName((Class)e.getClass()) + " - " + this.toString((TopiaEntity)e)).collect(Collectors.joining("\n")), I18n.t((String)"isisfish.message.delete.entities", (Object[])new Object[0]), 0);
                    doDelete = resp == 0;
                } else {
                    String text = I18n.t((String)"isisfish.message.confirm.delete.object", (Object[])new Object[]{this.toString((TopiaEntity)topiaEntity)});
                    int resp = JOptionPane.showConfirmDialog(null, text, I18n.t((String)"isisfish.message.delete.entity", (Object[])new Object[0]), 0);
                    boolean bl = doDelete = resp == 0;
                }
                if (doDelete) {
                    topiaEntity.delete();
                    topiaEntity.getTopiaContext().commitTransaction();
                    this.noModif();
                    InputUI inputUI = this.inputContentUI.getParentContainer(InputUI.class);
                    inputUI.getHandler().deleteTreeNode(topiaEntity.getTopiaId());
                }
            } else {
                String label = I18n.t((String)"isisfish.message.delete.referenced", (Object[])new Object[]{this.toString((TopiaEntity)topiaEntity)});
                String text = referencedEntitites.stream().map(e -> ClassUtils.getShortClassName((Class)e.getClass()) + " - " + this.toString((TopiaEntity)e)).collect(Collectors.joining("\n"));
                this.showTextAreaConfirmationMessage(null, label, text, I18n.t((String)"isisfish.message.delete.entities", (Object[])new Object[0]), 0);
            }
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't remove entity: " + String.valueOf(this.currentEntities.get(0)), eee);
        }
    }

    protected String toString(TopiaEntity e) {
        String result;
        try {
            result = BeanUtils.getProperty((Object)e, (String)"name");
        }
        catch (Exception ex) {
            result = e.toString();
        }
        return result;
    }

    public void create(Class<? extends TopiaEntityContextable> type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create called for " + String.valueOf(type)));
        }
        try {
            String typeSimpleName = type.getSimpleName();
            String name = typeSimpleName + "_new";
            TopiaContext topiaContext = this.inputContentUI.getTopiaContext();
            Method method = MethodUtils.getAccessibleMethod(IsisFishDAOHelper.class, (String)("get" + typeSimpleName + "DAO"), (Class[])new Class[]{TopiaContext.class});
            TopiaDAO dao = (TopiaDAO)method.invoke(null, topiaContext);
            TopiaEntityContextable topiaEntity = (TopiaEntityContextable)dao.create(new Object[]{"name", name});
            topiaContext.commitTransaction();
            InputUI inputUI = this.inputContentUI.getContextValue(InputUI.class, "parent");
            inputUI.getHandler().insertTreeNode(type, topiaEntity);
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.input.createentity", (Object[])new Object[0]), eee);
        }
    }

    public void save() {
        Object topiaEntity = this.inputContentUI.getBean();
        TopiaContext topiaContext = this.inputContentUI.getTopiaContext();
        try {
            for (TopiaEntityContextable entity : this.currentEntities.values()) {
                entity.update();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Updating verifier entity : " + String.valueOf(entity)));
            }
            topiaContext.commitTransaction();
            InputUI inputUI = this.inputContentUI.getParentContainer(InputUI.class);
            inputUI.getHandler().updateTreeNode(topiaEntity.getTopiaId());
            this.inputContentUI.resetChangeModel();
            this.noModif();
        }
        catch (TopiaException eee) {
            try {
                topiaContext.rollbackTransaction();
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.input.saveentity", (Object[])new Object[0]), eee);
            }
            catch (TopiaException eee2) {
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.input.saveentity", (Object[])new Object[0]), eee2);
            }
        }
    }

    public void cancel() {
        TopiaContext topiaContext = this.inputContentUI.getTopiaContext();
        Object topiaEntity = this.inputContentUI.getBean();
        if (topiaEntity == null) {
            return;
        }
        try {
            topiaContext.rollbackTransaction();
            this.noModif();
            Map canceledEntity = (Map)this.currentEntities.clone();
            this.currentEntities.clear();
            for (Map.Entry currentEntity : canceledEntity.entrySet()) {
                TopiaEntityContextable t = (TopiaEntityContextable)topiaContext.findByTopiaId(((TopiaEntityContextable)currentEntity.getValue()).getTopiaId());
                String key = (String)currentEntity.getKey();
                this.addCurrentEntity(t, key);
            }
            InputUI inputUI = this.inputContentUI.getParentContainer(InputUI.class);
            inputUI.getHandler().updateTreeNode(topiaEntity.getTopiaId());
            this.inputContentUI.resetChangeModel();
            topiaEntity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaEntity.getTopiaId());
            InputContentUI<?> inputContentUI2 = this.inputContentUI;
            inputContentUI2.setBean(null);
            inputContentUI2.setBean(topiaEntity);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.input.cancelentity", (Object[])new Object[0]), eee);
        }
    }

    protected int showTextAreaConfirmationMessage(Component parent, String labelMessage, String textMessage, String title, int option) {
        JLabel labelForMessage = new JLabel(labelMessage);
        JTextArea areaForMessage = new JTextArea(textMessage);
        areaForMessage.setEditable(false);
        areaForMessage.setAutoscrolls(true);
        JScrollPane spMessage = new JScrollPane(areaForMessage);
        spMessage.setPreferredSize(new Dimension(500, 100));
        int response = JOptionPane.showConfirmDialog(parent, new Object[]{labelForMessage, spMessage}, title, option);
        return response;
    }

    public void addCurrentEntity(TopiaEntityContextable currentEntity, String key) {
        if (currentEntity != null) {
            currentEntity.addPropertyChangeListener(this.entityPCL);
            this.currentEntities.put(key, currentEntity);
        }
    }

    public void addCurrentEntity(TopiaEntityContextable currentEntity) {
        if (currentEntity != null) {
            this.addCurrentEntity(currentEntity, currentEntity.getTopiaId());
        }
    }

    public void removeCurrentEntity(String key) {
        this.currentEntities.remove(key);
    }

    public void reset() {
        for (TopiaEntity topiaEntity : this.currentEntities.values()) {
            topiaEntity.removePropertyChangeListener(this.entityPCL);
        }
        this.currentEntities.clear();
        this.noModif();
    }

    public <E extends TopiaEntityContextable> E getEntity(Class<E> clazz, String key) {
        return (E)this.currentEntities.get(key);
    }

    public <E extends TopiaEntityContextable> E getEntity(Class<E> clazz) {
        for (TopiaEntity topiaEntity : this.currentEntities.values()) {
            if (!clazz.isInstance(topiaEntity)) continue;
            return (E)((TopiaEntityContextable)topiaEntity);
        }
        return null;
    }
}

