/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish;

import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import java.awt.AWTException;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public abstract class IsisTray
implements SimulationServiceListener,
PropertyChangeListener {
    protected static final Log log = LogFactory.getLog(IsisTray.class);
    protected static final ImageIcon TRAY_IMAGE_STOP = Resource.getIcon((String)"/images/BulbR.gif");
    protected static final ImageIcon TRAY_IMAGE_START = Resource.getIcon((String)"/images/BulbG.gif");
    private static final String NO_SIMULATION_TEXT = I18n.n((String)"isisfish.tray.simulation.no", (Object[])new Object[0]);
    private static final String SIMULATION_TEXT = I18n.n((String)"isisfish.tray.simulation", (Object[])new Object[0]);
    private static final String MULTI_SIMULATION_TEXT = I18n.n((String)"isisfish.tray.simulation.multi", (Object[])new Object[0]);
    private static IsisTray instance = null;

    public abstract void setImage(ImageIcon var1);

    public abstract void setToolTip(String var1);

    public static IsisTray getInstance() {
        if (instance == null) {
            instance = AWTSystemTray.isSupported() ? new AWTSystemTray() : new DummySystemTray();
            if (log.isInfoEnabled()) {
                log.info((Object)("Use system tray: " + instance.getClass().getName()));
            }
            instance.setToolTip(I18n.t((String)NO_SIMULATION_TEXT, (Object[])new Object[0]));
            SimulationService.getService().addSimulationServiceListener(instance);
        }
        return instance;
    }

    @Override
    public void simulationStart(SimulationService simService, SimulationJob job) {
        SimulationControl control = job.getItem().getControl();
        control.addPropertyChangeListener(this);
        IsisTray.getInstance().setToolTip(I18n.t((String)SIMULATION_TEXT, (Object[])new Object[]{control.getId(), control.getProgress(), control.getProgressMax()}));
        IsisTray.getInstance().setImage(TRAY_IMAGE_START);
    }

    @Override
    public void simulationStop(SimulationService simService, SimulationJob job) {
        SimulationControl control = job.getItem().getControl();
        control.removePropertyChangeListener(this);
        IsisTray.getInstance().setToolTip(I18n.t((String)NO_SIMULATION_TEXT, (Object[])new Object[0]));
        IsisTray.getInstance().setImage(TRAY_IMAGE_STOP);
    }

    @Override
    public void clearJobDone(SimulationService simService) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        SimulationControl control = (SimulationControl)evt.getSource();
        IsisTray.getInstance().setToolTip(I18n.t((String)SIMULATION_TEXT, (Object[])new Object[]{control.getId(), control.getProgress(), control.getProgressMax()}));
    }

    static class AWTSystemTray
    extends IsisTray {
        protected TrayIcon trayIcon = null;

        public static boolean isSupported() {
            boolean result = SystemTray.isSupported();
            return result;
        }

        @Override
        public void setImage(ImageIcon image) {
            this.trayIcon.setImage(image.getImage());
        }

        @Override
        public void setToolTip(String text) {
            this.trayIcon.setToolTip(text);
        }

        public AWTSystemTray() {
            if (SystemTray.isSupported()) {
                SystemTray tray = SystemTray.getSystemTray();
                this.trayIcon = new TrayIcon(TRAY_IMAGE_STOP.getImage(), I18n.t((String)NO_SIMULATION_TEXT, (Object[])new Object[0]), null);
                this.trayIcon.setImageAutoSize(true);
                try {
                    tray.add(this.trayIcon);
                }
                catch (AWTException eee) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)I18n.t((String)"isisfish.error.add.tray", (Object[])new Object[0]), (Throwable)eee);
                    }
                }
            } else {
                log.info((Object)I18n.t((String)"isisfish.message.tray.disabled", (Object[])new Object[0]));
            }
        }
    }

    static class DummySystemTray
    extends IsisTray {
        DummySystemTray() {
        }

        @Override
        public void setImage(ImageIcon image) {
        }

        @Override
        public void setToolTip(String text) {
        }
    }
}

