/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.cell;

import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.map.OpenMapEvents;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.cell.CellUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputUI;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.nuiton.i18n.I18n;

public class CellHandler
extends InputContentHandler<CellUI> {
    protected boolean init;

    protected CellHandler(CellUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((CellUI)this.inputContentUI).setButtonTitle(I18n.t((String)"isisfish.input.continueZones", (Object[])new Object[0]));
        ((CellUI)this.inputContentUI).setNextPath(I18n.n((String)"isisfish.input.tree.zones", (Object[])new Object[0]));
        new OpenMapEvents(((CellUI)this.inputContentUI).getCellMap(), (CoordMouseMode)new SelectMouseMode(false), 1){

            @Override
            public boolean mouseClicked(MouseEvent e) {
                boolean result = false;
                if (((CellUI)CellHandler.this.inputContentUI).getBean() != null) {
                    for (Cell c : ((CellUI)CellHandler.this.inputContentUI).getCellMap().getSelectedCells()) {
                        if (c.getTopiaId().equals(((CellUI)CellHandler.this.inputContentUI).getBean().getTopiaId())) continue;
                        ((CellUI)CellHandler.this.inputContentUI).getFieldCell().setSelectedItem(c);
                        result = true;
                    }
                }
                return result;
            }
        };
        ((CellUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CellHandler.this.init = true;
                GenericComboModel<Cell> cellModel = new GenericComboModel<Cell>();
                if (evt.getNewValue() == null) {
                    ((CellUI)((CellHandler)CellHandler.this).inputContentUI).fieldCellName.setText("");
                    ((CellUI)((CellHandler)CellHandler.this).inputContentUI).fieldCellLatitude.setText("");
                    ((CellUI)((CellHandler)CellHandler.this).inputContentUI).fieldCellLongitude.setText("");
                    ((CellUI)((CellHandler)CellHandler.this).inputContentUI).fieldCellComment.setText("");
                    ((CellUI)((CellHandler)CellHandler.this).inputContentUI).fieldCellLand.setSelected(false);
                }
                if (evt.getNewValue() != null) {
                    cellModel.setElementList(((CellUI)CellHandler.this.inputContentUI).getFisheryRegion().getCell());
                    cellModel.setSelectedItem(((CellUI)CellHandler.this.inputContentUI).getBean());
                }
                ((CellUI)((CellHandler)CellHandler.this).inputContentUI).fieldCell.setModel(cellModel);
                CellHandler.this.init = false;
            }
        });
    }

    protected void fieldCellChanged(ItemEvent event) {
        if (!this.init && event.getStateChange() == 1) {
            Cell c = (Cell)((CellUI)this.inputContentUI).fieldCell.getSelectedItem();
            if (c == null) {
                return;
            }
            Cell oldC = ((CellUI)this.inputContentUI).getBean();
            if (oldC != null && c.getTopiaId().equals(oldC.getTopiaId())) {
                return;
            }
            InputUI inputUI = ((CellUI)this.inputContentUI).getParentContainer(InputUI.class);
            if (inputUI != null) {
                inputUI.getHandler().setTreeSelection(this.inputContentUI, c.getTopiaId());
            } else {
                SensitivityInputUI sensitivityInputUI = ((CellUI)this.inputContentUI).getParentContainer(SensitivityInputUI.class);
                sensitivityInputUI.getHandler().setTreeSelection(this.inputContentUI, c.getTopiaId());
            }
        }
    }
}

