package fr.ifremer.isisfish.ui.simulator;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableModel;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class RuleChooser extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACTIVE = "active";
    public static final String PROPERTY_RULES_LIST = "rulesList";
    public static final String PROPERTY_SHOW_FACTOR_COLUMN = "showFactorColumn";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AVAILABLE_RULE_LIST_ENABLED = "availableRuleList.enabled";
    public static final String BINDING_SELECTED_RULE_PARAMETER_TABLE_MODEL_SHOW_FACTOR_COLUMN = "selectedRuleParameterTableModel.showFactorColumn";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JSCROLL_PANE1_ENABLED = "$JScrollPane1.enabled";
    private static final String BINDING_$JSCROLL_PANE2_ENABLED = "$JScrollPane2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28UNxR2tmzCEhKyCaRJoSVAWpUfmqVpqZCC+JFUaYgWCGwOqHupd8bJGnnswfYkA4eKP4E/gd57qdRbT1UPnDn0UvEvVFUPvVZ99mx2dsjsMGjIwZs8v/e973u2v81Pf6GqkujMIxxFjgy5pj5xNm49fHiv84i4+huiXEkDLSSKf0YqqNJG414/rjQ6126a8kavvLEq/EBwwgeql5voiNJPGFFdQrRGH6crXKUarf72chSEch+1TyoL9cU/f1eee89+rCAUBcDuOEhZeFtVouRQE1Wop9E0dNrFDYb5DtCQlO8A3wkTW2VYqbvYJ4/RD2isiUYDLAFMo7PFJVsMWx8FGo0tbuEOI5c1urQtHbotiU/gU1G1TVXXCamjqB8yDAjOgxCqu0IoIoPAQowCQBdzjxGp0ZfvArAeVyU4NQmbqkkVqJk0Wp1QU+aYQJI0il1Nd4lGdZthJuSsCMEI5knSlOqKvTXIFHJVsNDnJn482T+8uNHEHcJA87SBiRy1BzN24qhJqg3mbmKekWujB3Itwhfm7/nsvaWMvYnFjZYrBWMGExp9mGqUbKWr6pBEmTk7M9V4bvW0HIiZ5DP9mknseSZbrYRaC67RTKogjuaQs8rOpRNmFWHwMkkMbHreER5hGl0Zch18s60cV/i+4M63hBNJ3X5dckz1A8Bm4zOzXEjOGvDFrh1Bwv58muGUC/dDDujOyEnJXMqQeXqQzSaW8AY1kfbt9PTeKKS3ZZ9jH0AlCInyj4b3evMa2qApuxKA15xMeQ24mJO4WGIzI21UtY9No7n2QeMzTWPLm3vD8gyg3f1vduaPX1//srbvc/PQ+0Rm6oBNg/8EUgTgFNS0PhabnHnkjTs4WG6jWizbevipDGKt3jaQg371xCPWseoCRHXsz99+n/3+1QeosoaOMIG92ARuo5ruSpiCYF4U3LhpGR3dOwzrlOEGHka4mSNY7+Q1D2u80KHcg/lej2AKpzKm0KfSqb38d6b18839SYwAs/mh6ck0qt+hUcoZ5cR6fs/OMz1+PFAk9ERi21lGPmI+54LeHVqx61qW1EOaROAU09fi7gtYwxdMJ9QEtJqiDSvC/NYsiGnC62a5nY3wSSGETbPcL4OQx2GhyGSoG1tDCYxxDV9GWzTYgiHnCCoCddQljD0g3COSyBxan5YeztsRNKpaFysJMhE/cCq4Mbz3o2nIhD8vfemKIeTN9WIhhLyhXi6EEJZGeFoaIe8slkqfRTGEPA5fleZQDCHvPnxd4Ilk/u86BO9q6duxXIBRTYq9dUJ3unmGZoD+B/ZdS/m7DQAA";
    private static final Log log = LogFactory.getLog(RuleChooser.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean active;
    protected JButton addRulesButton;
    protected JList<String> availableRuleList;
    protected JButton clearRulesButton;
    protected RuleChooserHandler handler;
    protected JButton removeRuleButton;
    protected List<Rule> rulesList;
    protected JTable selectedRuleParameterTable;
    protected ScriptParametersTableModel selectedRuleParameterTableModel;
    protected JList<Rule> selectedRulesList;
    protected GenericListModel<Rule> selectedRulesListModel;
    protected Boolean showFactorColumn;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private RuleChooser $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RuleChooser() {
        $initialize();
    }

    public RuleChooser(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addRulesButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addSelectedRules();
    }

    public void doActionPerformed__on__clearRulesButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.clearAllRules();
    }

    public void doActionPerformed__on__removeRuleButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeSelectedRules();
    }

    public void doValueChanged__on__availableRuleList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addRulesButton.setEnabled(availableRuleList.getSelectedIndex() != -1);
    }

    public void doValueChanged__on__selectedRulesList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeRuleButton.setEnabled(selectedRulesList.getSelectedIndex() != -1);clearRulesButton.setEnabled(selectedRulesList.getSelectedIndex() != -1);handler.displayRuleParameters();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getActive() {
        return active;
    }

    public JButton getAddRulesButton() {
        return addRulesButton;
    }

    public JList<String> getAvailableRuleList() {
        return availableRuleList;
    }

    public JButton getClearRulesButton() {
        return clearRulesButton;
    }

    public RuleChooserHandler getHandler() {
        return handler;
    }

    public JButton getRemoveRuleButton() {
        return removeRuleButton;
    }

    public List<Rule> getRulesList() {
        return rulesList;
    }

    public JTable getSelectedRuleParameterTable() {
        return selectedRuleParameterTable;
    }

    public ScriptParametersTableModel getSelectedRuleParameterTableModel() {
        return selectedRuleParameterTableModel;
    }

    public JList<Rule> getSelectedRulesList() {
        return selectedRulesList;
    }

    public GenericListModel<Rule> getSelectedRulesListModel() {
        return selectedRulesListModel;
    }

    public Boolean getShowFactorColumn() {
        return showFactorColumn;
    }

    public Boolean isActive() {
        return active !=null && active;
    }

    public Boolean isShowFactorColumn() {
        return showFactorColumn !=null && showFactorColumn;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setActive(Boolean active) {
        Boolean oldValue = this.active;
        this.active = active;
        firePropertyChange(PROPERTY_ACTIVE, oldValue, active);
    }

    public void setRulesList(List<Rule> rulesList) {
        List<Rule> oldValue = this.rulesList;
        this.rulesList = rulesList;
        firePropertyChange(PROPERTY_RULES_LIST, oldValue, rulesList);
    }

    public void setShowFactorColumn(Boolean showFactorColumn) {
        Boolean oldValue = this.showFactorColumn;
        this.showFactorColumn = showFactorColumn;
        firePropertyChange(PROPERTY_SHOW_FACTOR_COLUMN, oldValue, showFactorColumn);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createActive() {
        $objectMap.put("active", active = true);
    }

    protected void createAddRulesButton() {
        $objectMap.put("addRulesButton", addRulesButton = new JButton());
        
        addRulesButton.setName("addRulesButton");
        addRulesButton.setEnabled(false);
        addRulesButton.setText(t("isisfish.common.add"));
        addRulesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addRulesButton"));
    }

    protected void createAvailableRuleList() {
        $objectMap.put("availableRuleList", availableRuleList = new JList<String>());
        
        availableRuleList.setName("availableRuleList");
        availableRuleList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__availableRuleList"));
    }

    protected void createClearRulesButton() {
        $objectMap.put("clearRulesButton", clearRulesButton = new JButton());
        
        clearRulesButton.setName("clearRulesButton");
        clearRulesButton.setEnabled(false);
        clearRulesButton.setText(t("isisfish.common.clear"));
        clearRulesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearRulesButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new RuleChooserHandler(this));
    }

    protected void createRemoveRuleButton() {
        $objectMap.put("removeRuleButton", removeRuleButton = new JButton());
        
        removeRuleButton.setName("removeRuleButton");
        removeRuleButton.setEnabled(false);
        removeRuleButton.setText(t("isisfish.common.remove"));
        removeRuleButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeRuleButton"));
    }

    protected void createRulesList() {
        $objectMap.put("rulesList", rulesList = new java.util.ArrayList<>());
    }

    protected void createSelectedRuleParameterTable() {
        $objectMap.put("selectedRuleParameterTable", selectedRuleParameterTable = new JTable());
        
        selectedRuleParameterTable.setName("selectedRuleParameterTable");
        selectedRuleParameterTable.setRowHeight(24);
    }

    protected void createSelectedRuleParameterTableModel() {
        $objectMap.put("selectedRuleParameterTableModel", selectedRuleParameterTableModel = new ScriptParametersTableModel());
    }

    protected void createSelectedRulesList() {
        $objectMap.put("selectedRulesList", selectedRulesList = new JList<Rule>());
        
        selectedRulesList.setName("selectedRulesList");
        selectedRulesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectedRulesList"));
    }

    protected void createSelectedRulesListModel() {
        $objectMap.put("selectedRulesListModel", selectedRulesListModel = new GenericListModel<Rule>());
    }

    protected void createShowFactorColumn() {
        $objectMap.put("showFactorColumn", showFactorColumn = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addRulesButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(2, 1, 2, 3, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(removeRuleButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(clearRulesButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane2, new GridBagConstraints(0, 4, 4, 1, 2.0, 2.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(availableRuleList);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(selectedRulesList);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(selectedRuleParameterTable);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        $JLabel2.setIcon(SwingUtil.createImageIcon("common/information-small.png"));
        availableRuleList.setCellRenderer(new fr.ifremer.isisfish.ui.models.rule.RuleNamesListRenderer());
        availableRuleList.setModel(new fr.ifremer.isisfish.ui.models.common.GenericListModel<String>(fr.ifremer.isisfish.datastore.RuleStorage.getRuleNames()));
        availableRuleList.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        selectedRulesList.setCellRenderer(new fr.ifremer.isisfish.ui.models.rule.RuleListCellRenderer());
        selectedRulesList.setModel(selectedRulesListModel);
        selectedRulesList.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        selectedRuleParameterTable.setModel(selectedRuleParameterTableModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createRulesList();
        createActive();
        createShowFactorColumn();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.params.rules.availables"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.params.rules.selected"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setToolTipText(t("isisfish.params.rules.tooltip"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createAvailableRuleList();
        createAddRulesButton();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createSelectedRulesListModel();
        createSelectedRulesList();
        createRemoveRuleButton();
        createClearRulesButton();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createSelectedRuleParameterTableModel();
        createSelectedRuleParameterTable();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_AVAILABLE_RULE_LIST_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                availableRuleList.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JSCROLL_PANE1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JScrollPane1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JSCROLL_PANE2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JScrollPane2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTED_RULE_PARAMETER_TABLE_MODEL_SHOW_FACTOR_COLUMN, true ,"showFactorColumn") {
        
            @Override
            public void processDataBinding() {
                selectedRuleParameterTableModel.setShowFactorColumn(isShowFactorColumn());
            }
        });
    }

}