/*
 * #%L
 * $Id: GearHandler.java 4237 2015-05-27 13:00:56Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/input/gear/GearHandler.java $
 * %%
 * Copyright (C) 2015 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.gear;

import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import fr.ifremer.isisfish.ui.input.InputContentHandler;

/**
 * Gear handler.
 */
public class GearHandler extends InputContentHandler<GearUI> {

    protected GearHandler(GearUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        inputContentUI.setButtonTitle(t("isisfish.input.continueMetiers"));
        inputContentUI.setNextPath(n("isisfish.input.tree.metiers"));
        
        inputContentUI.addPropertyChangeListener(GearUI.PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {

                }
                if (evt.getNewValue() != null) {
                    //getVerifier().addCurrentPanel(gearTabUI, selectivityUI);
                }
            }
        });
        
        // install change listener
        // (depends on sensitivity can't be done on constructor)
        inputContentUI.installChangeListener(inputContentUI.gearTab);
    }
}
