/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.export;

import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.VoyageService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.util.Version;

public class CreateEmbeddedApplication
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> voyages;
    protected String fileName;
    protected String warFileName;

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public Set<String> getVoyageIds() {
        return this.voyages.keySet();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getWarFileName() {
        return this.warFileName;
    }

    public String execute() throws Exception {
        VoyageService service = (VoyageService)this.newService(VoyageService.class);
        List allVoyages = service.getEntities(Voyage.class);
        this.voyages = this.sortAndDecorate((Collection)allVoyages, null);
        EchoBaseConfiguration configuration = this.getConfiguration();
        Version version = configuration.getApplicationVersion();
        this.fileName = "echobase-embedded-" + version.toString();
        File warLocation = configuration.getWarLocation();
        if (!warLocation.exists()) {
            this.addActionError(this._("echobase.error.warlocation.notFound", new Object[]{warLocation}));
        }
        this.warFileName = warLocation.getName();
        return "success";
    }
}

