/*
 * #%L
 * $Id: CommonZone.java 797 2011-03-24 15:45:33Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.0.9/coser-web/src/main/java/fr/ifremer/coser/web/actions/common/CommonZone.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.common;

import java.util.Map;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;

/**
 * Affiche la liste des sous zones (zone) et leurs liste des cartes
 * et commentaires associés.
 * 
 * @author chatellier
 * @version $Revision: 797 $
 * 
 * Last update : $Date: 2011-03-24 16:45:33 +0100 (jeu., 24 mars 2011) $
 * By : $Author: chatellier $
 */
public abstract class CommonZone extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3385467755357775199L;

    protected String facade;

    protected Map<String, String> zones;

    protected Map<String, String> zonesPictures;

    protected Map<String, String> zonesMetaInfo;

    public String getFacade() {
        return facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public Map<String, String> getZones() {
        return zones;
    }

    public Map<String, String> getZonesPictures() {
        return zonesPictures;
    }

    public Map<String, String> getZonesMetaInfo() {
        return zonesMetaInfo;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getFacades().get(facade);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", ex);
        }
        return displayName;
    }

    @Override
    public String execute() {

        WebService webService = ServiceFactory.getWebService();

        try {
            // renvoi la liste des id subzone-survey et leurs label associé
            zones = webService.getZoneForFacade(facade, false, false);
            zonesPictures = webService.getZonePictures();
            zonesMetaInfo = webService.getZoneMetaInfo();
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone map", ex);
        }

        return SUCCESS;
    }
}
