package fr.ifremer.coselmar.persistence.entity;

/*
 * #%L
 * Coselmar :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import fr.ifremer.coselmar.beans.QuestionSearchBean;
import fr.ifremer.coselmar.persistence.DaoUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

public class QuestionTopiaDao extends AbstractQuestionTopiaDao<Question> {

    public List<Question> findForExpert(CoselmarUser expert, QuestionSearchBean searchBean) {

        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q "
            + " INNER JOIN Q." + Question.PROPERTY_PARTICIPANTS + " CUG ");

        Map<String, Object> args = new HashMap<>();

        String publicCondition = DaoUtils.getQueryForAttributeEquals("Q", Question.PROPERTY_PRIVACY, args, Privacy.PUBLIC, "");

        hqlBuilder.append(" WHERE ( (" + publicCondition + " ) ");

        String privateCondition = DaoUtils.getQueryForAttributeEquals("Q", Question.PROPERTY_PRIVACY, args, Privacy.PRIVATE, "");

        hqlBuilder.append(" OR (" + privateCondition);

        String participantCondition = DaoUtils.andAttributeContains("CUG", CoselmarUserGroup.PROPERTY_MEMBERS, args, expert);
        hqlBuilder.append(participantCondition);

        String clientCondition = DaoUtils.andAttributeContains("Q", Question.PROPERTY_CLIENTS, args, expert);

        hqlBuilder.append(clientCondition + ") )");

        String finerHql = refineSearch(searchBean, "Q", args);
        hqlBuilder.append(" AND (" + finerHql + ")" );


        List<Question> questions = forHql(hqlBuilder.toString(), args).findAll();

        return questions;
    }

    public List<Question> findForExpert(CoselmarUser expert) {

        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q "
            + " INNER JOIN Q." + Question.PROPERTY_PARTICIPANTS + " CUG ");

        Map<String, Object> args = new HashMap<>();

        String publicCondition = DaoUtils.getQueryForAttributeEquals("Q", Question.PROPERTY_PRIVACY, args, Privacy.PUBLIC, "");

        hqlBuilder.append(" WHERE ( (" + publicCondition + " ) ");

        String privateCondition = DaoUtils.getQueryForAttributeEquals("Q", Question.PROPERTY_PRIVACY, args, Privacy.PRIVATE, "");

        hqlBuilder.append(" OR (" + privateCondition);

        String participantCondition = DaoUtils.andAttributeContains("CUG", CoselmarUserGroup.PROPERTY_MEMBERS, args, expert);
        hqlBuilder.append(participantCondition);

        String clientCondition = DaoUtils.andAttributeContains("Q", Question.PROPERTY_CLIENTS, args, expert);

        hqlBuilder.append(clientCondition + ") )");

        List<Question> questions = forHql(hqlBuilder.toString(), args).findAll();

        return questions;
    }

    public List<Question> findForExpert(CoselmarUser expert, List<String> topiaIds) {

        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q "
            + " INNER JOIN Q." + Question.PROPERTY_PARTICIPANTS + " CUG ");

        Map<String, Object> args = new HashMap<>();

        String publicCondition = DaoUtils.getQueryForAttributeEquals("Q", Question.PROPERTY_PRIVACY, args, Privacy.PUBLIC, "");

        hqlBuilder.append(" WHERE ( (" + publicCondition + " ) ");

        String privateCondition = DaoUtils.getQueryForAttributeEquals("Q", Question.PROPERTY_PRIVACY, args, Privacy.PRIVATE, "");

        hqlBuilder.append(" OR (" + privateCondition + " AND ( 0 = 1 ");

        String participantCondition = DaoUtils.orAttributeContains("CUG", CoselmarUserGroup.PROPERTY_MEMBERS, args, expert);
        hqlBuilder.append(participantCondition);

        String clientCondition = DaoUtils.orAttributeContains("Q", Question.PROPERTY_CLIENTS, args, expert);

        hqlBuilder.append(clientCondition + ") ) )");

        String topiaIdsCondition = DaoUtils.andAttributeIn("Q", Question.PROPERTY_TOPIA_ID, args, topiaIds);
        hqlBuilder.append(topiaIdsCondition);

        List<Question> questions = forHql(hqlBuilder.toString(), args).findAll();

        return questions;
    }

    public List<Question> findForClient(CoselmarUser client, QuestionSearchBean searchBean) {

        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q ");

        Map<String, Object> args = new HashMap<>();

        String clientCondition = DaoUtils.andAttributeContains("Q", Question.PROPERTY_CLIENTS, args, client);

        hqlBuilder.append(" WHERE 1=1 AND (" + clientCondition + " ) ");

        if (searchBean != null) {
            String finerHql = refineSearch(searchBean, "Q", args);
            hqlBuilder.append(" AND (" + finerHql + ")" );
        }

        List<Question> questions = forHql(hqlBuilder.toString(), args).findAll();

        return questions;
    }

    public List<Question> findForClient(CoselmarUser client, List<String> topiaIds) {

        TopiaQueryBuilderAddCriteriaOrRunQueryStep<Question> queryBuilder = forTopiaIdIn(topiaIds);
        queryBuilder.addContains(Question.PROPERTY_CLIENTS, client);

        List<Question> questions = queryBuilder.findAll();

        return questions;
    }

    public List<Question> findWithSearchBean(QuestionSearchBean searchBean) {

        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q ");

        Map<String, Object> args = new HashMap<>();

        if (searchBean != null) {
            String finerHql = refineSearch(searchBean, "Q", args);
            hqlBuilder.append(" WHERE (" + finerHql + ")" );
        }

        List<Question> questions = forHql(hqlBuilder.toString(), args).findAll();

        return questions;
    }

    public List<String> findAllThemes() {

        StringBuilder hqlBuilder =
            new StringBuilder("SELECT DISTINCT(themes)"
                + " FROM " + Question.class.getName() + " Q "
                + " INNER JOIN Q." + Question.PROPERTY_THEME + " themes ");

        List<String> values = findAll(hqlBuilder.toString());

        return values;
    }

    public List<String> findAllTypes() {

        StringBuilder hqlBuilder =
            new StringBuilder("SELECT DISTINCT(Q. " + Question.PROPERTY_TYPE + ")"
                + " FROM " + Question.class.getName() + " Q ");

        List<String> values = findAll(hqlBuilder.toString());

        return values;
    }

    public String refineSearch(QuestionSearchBean searchBean, String alias, Map args) {

        StringBuilder finerHqlBuilder = new StringBuilder(" 1=1 ");

        String privacy = searchBean.getPrivacy();

        if (StringUtils.isNotBlank(privacy)) {
            String privacyHql = DaoUtils.andAttributeEquals(alias, Question.PROPERTY_PRIVACY, args, Privacy.valueOf(privacy.toUpperCase()));
            finerHqlBuilder.append(privacyHql);
        }

        String status = searchBean.getStatus();

        if (StringUtils.isNotBlank(status)) {
            String statusHql = DaoUtils.andAttributeEquals(alias, Question.PROPERTY_STATUS, args, Status.valueOf(status.toUpperCase()));
            finerHqlBuilder.append(statusHql);
        }

        List<String> keywords = searchBean.getKeywords();
        if (keywords != null && !keywords.isEmpty()) {
            // should be like : """ ( (1=1)
            // AND ( 1=0 OR title like keyword1 OR summary like keyword1 OR theme contains keyword1 )
            // AND ( 1=0 OR title like keyword2 OR summary like keyword2 OR theme contains keyword2 )
            // ) """
            StringBuilder keywordsBuilder = new StringBuilder(" ( ( 1 = 1 ) ");

            for (String keyword : keywords) {
                keywordsBuilder.append(" AND ( 1=0 ");
                keywordsBuilder.append(DaoUtils.orAttributeLike(alias, Question.PROPERTY_TITLE, args, keyword));
                keywordsBuilder.append(DaoUtils.orAttributeLike(alias, Question.PROPERTY_SUBMISSION_DATE, args, keyword));
                keywordsBuilder.append(DaoUtils.orAttributeContains(alias, Question.PROPERTY_THEME, args, keyword));
                keywordsBuilder.append(" ) ");
            }

            keywordsBuilder.append(" ) ");
            String keywordHql = keywordsBuilder.toString();
            finerHqlBuilder.append(" AND " + keywordHql);
        }

        String finerHql = finerHqlBuilder.toString();
        return finerHql;
    }

} //QuestionTopiaDao
