/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.grouperClientMail;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.Morph;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class GrouperClientEmail {
    private String to;
    private String subject;
    private String from;
    private String body;

    public GrouperClientEmail setTo(String theToAddress) {
        this.to = theToAddress;
        return this;
    }

    public GrouperClientEmail setSubject(String theSubject) {
        this.subject = theSubject;
        return this;
    }

    public GrouperClientEmail setBody(String theBody) {
        this.body = theBody;
        return this;
    }

    public GrouperClientEmail setFrom(String theFrom) {
        this.from = theFrom;
        return this;
    }

    public static void main(String[] args) {
        new GrouperClientEmail().setBody("hey").setSubject("subject").setTo("mchyzer@yahoo.com,mchyzer@isc.upenn.edu").send();
    }

    public void send() {
        try {
            String theFrom = GrouperClientUtils.defaultIfEmpty(this.from, GrouperClientUtils.propertiesValue("grouperClient.mail.from.address", false));
            if (GrouperClientUtils.isBlank(theFrom)) {
                throw new RuntimeException("You need to specify the from email address mail.from.address in grouper.client.properties");
            }
            String smtpServer = GrouperClientUtils.propertiesValue("grouperClient.mail.smtp.server", false);
            if (GrouperClientUtils.isBlank(smtpServer)) {
                throw new RuntimeException("You need to specify the from smtp server mail.smtp.server in grouper.client.properties");
            }
            String subjectPrefix = GrouperClientUtils.defaultString(GrouperClientUtils.propertiesValue("grouperClient.mail.subject.prefix", false));
            final String SMTP_USER = GrouperClientUtils.propertiesValue("grouperClient.mail.smtp.user", false);
            String smtpPass = GrouperClientUtils.propertiesValue("grouperClient.mail.smtp.pass", false);
            final String SMTP_PASS = GrouperClientUtils.isBlank(smtpPass) ? null : Morph.decryptIfFile(smtpPass);
            Properties properties = new Properties();
            properties.put("mail.host", smtpServer);
            properties.put("mail.transport.protocol", "smtp");
            Authenticator authenticator = null;
            if (!GrouperClientUtils.isBlank(SMTP_USER)) {
                properties.setProperty("mail.smtp.submitter", SMTP_USER);
                properties.setProperty("mail.smtp.auth", "true");
                authenticator = new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(SMTP_USER, SMTP_PASS);
                    }
                };
            }
            Session session = Session.getInstance((Properties)properties, authenticator);
            MimeMessage message = new MimeMessage(session);
            String theTo = this.to;
            if (!GrouperClientUtils.isBlank(theTo)) {
                String[] theTos;
                theTo = GrouperClientUtils.replace(theTo, ";", ",");
                for (String aTo : theTos = GrouperClientUtils.splitTrim(theTo, ",")) {
                    message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(aTo));
                }
            }
            message.addFrom((Address[])new InternetAddress[]{new InternetAddress(theFrom)});
            String theSubject = GrouperClientUtils.defaultString(subjectPrefix) + this.subject;
            message.setSubject(theSubject);
            message.setContent((Object)this.body, "text/plain");
            Transport.send((Message)message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

