/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.util.GrouperClientCommonUtils;
import edu.internet2.middleware.grouperClient.util.GrouperClientLog;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.Expression;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.ExpressionFactory;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.JexlContext;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.JexlHelper;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.impl.Jdk14Logger;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrouperClientUtils
extends GrouperClientCommonUtils {
    private static boolean configuredLogs = false;
    private static Map<String, String> grouperClientOverrideMap = new LinkedHashMap<String, String>();
    private static Log LOG = GrouperClientUtils.retrieveLog(GrouperClientUtils.class);

    public static Log retrieveLog(Class<?> theClass) {
        Log theLog = LogFactory.getLog(theClass);
        if (GrouperClientUtils.isBlank(GrouperClientUtils.propertiesValue("encrypt.disableExternalFileLookup", false)) || theClass.equals(GrouperClientCommonUtils.class)) {
            return new GrouperClientLog(theLog);
        }
        if (!configuredLogs) {
            boolean hasGrouperClientLogLevel;
            String logLevel = GrouperClientUtils.propertiesValue("grouperClient.logging.logLevel", false);
            String logFile = GrouperClientUtils.propertiesValue("grouperClient.logging.logFile", false);
            String grouperClientLogLevel = GrouperClientUtils.propertiesValue("grouperClient.logging.grouperClientOnly.logLevel", false);
            boolean hasLogLevel = !GrouperClientUtils.isBlank(logLevel);
            boolean hasLogFile = !GrouperClientUtils.isBlank(logFile);
            boolean bl = hasGrouperClientLogLevel = !GrouperClientUtils.isBlank(grouperClientLogLevel);
            if ((hasLogLevel || hasLogFile) && theLog instanceof Jdk14Logger) {
                Jdk14Logger jdkLogger = (Jdk14Logger)theLog;
                Logger logger = jdkLogger.getLogger();
                long timeToLive = 60L;
                while (logger.getParent() != null && timeToLive-- > 0L) {
                    logger = logger.getParent();
                }
                if (GrouperClientUtils.length(logger.getHandlers()) == 1 && logger.getHandlers()[0].getClass() == ConsoleHandler.class) {
                    logger.removeHandler(logger.getHandlers()[0]);
                }
                if (GrouperClientUtils.length(logger.getHandlers()) == 0) {
                    StreamHandler handler = null;
                    if (hasLogFile) {
                        try {
                            handler = new FileHandler(logFile, true);
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    } else {
                        handler = new ConsoleHandler();
                    }
                    handler.setFormatter(new SimpleFormatter());
                    handler.setLevel(Level.ALL);
                    logger.addHandler(handler);
                    logger.setUseParentHandlers(false);
                }
                if (hasLogLevel) {
                    Level level = Level.parse(logLevel);
                    logger.setLevel(level);
                }
            }
            if (hasGrouperClientLogLevel) {
                Level level = Level.parse(grouperClientLogLevel);
                Log grouperClientLog = LogFactory.getLog("edu.internet2.middleware.grouperClient");
                if (grouperClientLog instanceof Jdk14Logger) {
                    Jdk14Logger jdkLogger = (Jdk14Logger)grouperClientLog;
                    Logger logger = jdkLogger.getLogger();
                    logger.setLevel(level);
                }
            }
            configuredLogs = true;
        }
        return new GrouperClientLog(theLog);
    }

    public static Map<String, String> grouperClientOverrideMap() {
        return grouperClientOverrideMap;
    }

    public static Properties grouperClientProperties() {
        Properties properties = null;
        try {
            properties = GrouperClientUtils.propertiesFromResourceName("grouper.client.properties", true, true, GrouperClientCommonUtils.class, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing file: grouper.client.properties  This properties file needs to be in the same directory as grouperClient.jar, or on your Java classpath", e);
        }
        return properties;
    }

    public static String propertiesValue(String key, boolean required) {
        return GrouperClientUtils.propertiesValue("grouper.client.properties", GrouperClientUtils.grouperClientProperties(), GrouperClientUtils.grouperClientOverrideMap(), key, required);
    }

    public static boolean propertiesValueBoolean(String key, boolean defaultValue, boolean required) {
        return GrouperClientUtils.propertiesValueBoolean("grouper.client.properties", GrouperClientUtils.grouperClientProperties(), GrouperClientUtils.grouperClientOverrideMap(), key, defaultValue, required);
    }

    public static int propertiesValueInt(String key, int defaultValue, boolean required) {
        return GrouperClientUtils.propertiesValueInt("grouper.client.properties", GrouperClientUtils.grouperClientProperties(), GrouperClientUtils.grouperClientOverrideMap(), key, defaultValue, required);
    }

    public static String substituteExpressionLanguage(String stringToParse, Map<String, Object> variableMap) {
        if (GrouperClientUtils.isBlank(stringToParse)) {
            return stringToParse;
        }
        try {
            JexlContext jc = JexlHelper.createContext();
            int index = 0;
            for (String key : variableMap.keySet()) {
                jc.getVars().put(key, variableMap.get(key));
            }
            Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
            Matcher matcher = pattern.matcher(stringToParse);
            StringBuilder result = new StringBuilder();
            while (matcher.find()) {
                result.append(stringToParse.substring(index, matcher.start()));
                String script = matcher.group(1);
                Expression e = ExpressionFactory.createExpression(script);
                Object o = e.evaluate(jc);
                if (o == null) {
                    LOG.warn("expression returned null: " + script + ", in pattern: '" + stringToParse + "', available variables are: " + GrouperClientUtils.toStringForLog(variableMap.keySet()));
                }
                result.append(o);
                index = matcher.end();
            }
            result.append(stringToParse.substring(index, stringToParse.length()));
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error substituting string: '" + stringToParse + "'", e);
        }
    }
}

