/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.util.ExpirableCache;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpirableValue<T>
implements Serializable {
    private long timePlacedInCache = System.currentTimeMillis();
    private long timeToLiveInCacheMillis = ExpirableCache.MAX_TIME_TO_LIVE_MILLIS;
    private T content = null;

    ExpirableValue(T theContent, long theTimeToLiveInCacheMillis) {
        if (theTimeToLiveInCacheMillis > 0L && theTimeToLiveInCacheMillis <= ExpirableCache.MAX_TIME_TO_LIVE_MILLIS) {
            this.timeToLiveInCacheMillis = theTimeToLiveInCacheMillis;
        }
        this.content = theContent;
    }

    T getContent() {
        GrouperClientUtils.assertion(!this.expiredLongTime(), "This content is expired!");
        return this.content;
    }

    boolean expired() {
        return System.currentTimeMillis() - this.timePlacedInCache > this.timeToLiveInCacheMillis;
    }

    boolean expiredLongTime() {
        return System.currentTimeMillis() - 3000L - this.timePlacedInCache > this.timeToLiveInCacheMillis;
    }
}

