/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.WsMemberFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsHasMemberResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestHasMemberRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcHasMember {
    private String clientVersion;
    private String groupName;
    private String groupUuid;
    private List<WsSubjectLookup> subjectLookups = new ArrayList<WsSubjectLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private String fieldName;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private WsMemberFilter memberFilter;

    public GcHasMember assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcHasMember assignGroupName(String theGroupName) {
        this.groupName = theGroupName;
        return this;
    }

    public GcHasMember assignGroupUuid(String theGroupUuid) {
        this.groupUuid = theGroupUuid;
        return this;
    }

    public GcHasMember addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcHasMember addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcHasMember addSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.subjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcHasMember addSubjectId(String subjectId) {
        this.subjectLookups.add(new WsSubjectLookup(subjectId, null, null));
        return this;
    }

    public GcHasMember addSubjectIdentifier(String subjectIdentifier) {
        this.subjectLookups.add(new WsSubjectLookup(null, null, subjectIdentifier));
        return this;
    }

    public GcHasMember assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.isBlank(this.groupName) && GrouperClientUtils.isBlank(this.groupUuid)) {
            throw new RuntimeException("Group name or uuid is required: " + this);
        }
        if (GrouperClientUtils.isNotBlank(this.groupName) && GrouperClientUtils.isNotBlank(this.groupUuid)) {
            throw new RuntimeException("Group name and uuid cannot both be filled in at once : " + this);
        }
        if (GrouperClientUtils.length(this.subjectLookups) == 0) {
            throw new RuntimeException("Need at least one subject to add to group: " + this);
        }
    }

    public GcHasMember assignFieldName(String theFieldName) {
        this.fieldName = theFieldName;
        return this;
    }

    public GcHasMember addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcHasMember assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcHasMember assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsHasMemberResults execute() {
        this.validate();
        WsHasMemberResults wsHasMemberResults = null;
        try {
            WsRestHasMemberRequest hasMember = new WsRestHasMemberRequest();
            hasMember.setActAsSubjectLookup(this.actAsSubject);
            hasMember.setFieldName(this.fieldName);
            hasMember.setMemberFilter(this.memberFilter == null ? null : this.memberFilter.name());
            if (this.includeGroupDetail != null) {
                hasMember.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                hasMember.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            WsGroupLookup wsGroupLookup = new WsGroupLookup();
            if (!GrouperClientUtils.isBlank(this.groupName)) {
                wsGroupLookup.setGroupName(this.groupName);
            }
            if (!GrouperClientUtils.isBlank(this.groupUuid)) {
                wsGroupLookup.setUuid(this.groupUuid);
            }
            hasMember.setWsGroupLookup(wsGroupLookup);
            if (this.subjectAttributeNames.size() > 0) {
                hasMember.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            WsSubjectLookup[] subjectLookupsResults = GrouperClientUtils.toArray(this.subjectLookups, WsSubjectLookup.class);
            hasMember.setSubjectLookups(subjectLookupsResults);
            if (this.params.size() > 0) {
                hasMember.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            String urlSuffix = "groups";
            wsHasMemberResults = (WsHasMemberResults)grouperClientWs.executeService(urlSuffix, hasMember, "hasMember", this.clientVersion);
            String resultMessage = wsHasMemberResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsHasMemberResults, wsHasMemberResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsHasMemberResults;
    }

    public GcHasMember assignMemberFilter(WsMemberFilter theMemberFilter) {
        this.memberFilter = theMemberFilter;
        return this;
    }
}

